/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import com.android.utils.PathUtils;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchUninstaller
extends AbstractUninstaller
implements PatchOperation {
    private final LocalPackage myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
    private final Path myEmptyDir;
    private Path myGeneratedPatch;

    public PatchUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr) {
        super(p, mgr);
        this.myEmptyDir = FileOpUtils.getNewTempDir((String)"PatchUninstaller", (FileSystem)p.getLocation().getFileSystem());
        this.registerStateChangeListener((op, progress2) -> {
            if (this.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
                try {
                    PathUtils.deleteRecursivelyIfExists((Path)this.getLocation(progress2));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    @NotNull
    public LocalPackage getPatcher(@NotNull ProgressIndicator progressIndicator) {
        return this.myPatcher;
    }

    @Override
    @NotNull
    public Path getNewFilesRoot() {
        return this.myEmptyDir;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        return "<None>";
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.getPackage();
    }

    protected boolean doPrepare(@Nullable Path installTemp, ProgressIndicator progress2) {
        if (this.myPatcher == null) {
            return false;
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTemp, progress2);
        return this.myGeneratedPatch != null;
    }

    protected boolean doComplete(@Nullable Path installTemp, @NotNull ProgressIndicator progress2) {
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, progress2);
    }
}

