/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.install.StudioSdkInstallListenerFactory;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.utils.PathUtils;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallingRestarter {
    private static final String OLD_PACKAGE_XML_FN = "package.xml.old";
    private final AndroidSdkHandler mySdkHandler;

    public PatchInstallingRestarter(@NotNull AndroidSdkHandler sdkHandler) {
        this.mySdkHandler = sdkHandler;
    }

    public void restartAndInstallIfNecessary() {
        Path sdkLocation = this.mySdkHandler.getLocation();
        if (sdkLocation == null) {
            return;
        }
        Path patchesDir = sdkLocation.resolve(".patches");
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        try (Stream subDirs = CancellableFileIo.list((Path)patchesDir);){
            subDirs.filter(file2 -> CancellableFileIo.isDirectory((Path)file2, (LinkOption[])new LinkOption[0]) && file2.getFileName().toString().startsWith(PatchInstallerUtil.PATCH_DIR_PREFIX)).forEach(patchDir -> this.processPatch(sdkLocation, progress2, (Path)patchDir));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processPatch(Path androidSdkPath, StudioLoggerProgressIndicator progress2, Path patchDir) {
        LocalPackage pendingPackage = null;
        Path installDir = null;
        try {
            RepoManager mgr = this.mySdkHandler.getSdkManager((ProgressIndicator)progress2);
            Repository repo = InstallerUtil.readPendingPackageXml((Path)patchDir, (RepoManager)mgr, (ProgressIndicator)progress2);
            if (repo != null) {
                Path patch = patchDir.resolve("patch.jar");
                pendingPackage = repo.getLocalPackage();
                boolean remote = false;
                if (pendingPackage != null) {
                    installDir = ((LocalPackage)mgr.getPackages().getLocalPackages().get(pendingPackage.getPath())).getLocation();
                } else {
                    pendingPackage = (RepoPackage)repo.getRemotePackage().get(0);
                    installDir = ((RemotePackage)pendingPackage).getInstallDir(mgr, (ProgressIndicator)progress2);
                    remote = true;
                }
                Path existingPackageXml = installDir.resolve("package.xml");
                Path oldPackageXml = patchDir.resolve(OLD_PACKAGE_XML_FN);
                if (CancellableFileIo.exists((Path)patch, (LinkOption[])new LinkOption[0])) {
                    try {
                        Files.move(existingPackageXml, oldPackageXml, new CopyOption[0]);
                        throw new UnsupportedOperationException("TODO: Merge");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                String relativePath = androidSdkPath.relativize(installDir).toString();
                Revision rev = AndroidBuildCommonUtils.parsePackageRevision((String)androidSdkPath.toString(), (String)relativePath);
                if (rev != null && rev.equals((Object)pendingPackage.getVersion())) {
                    DummyInstallerFactory dummyFactory = new DummyInstallerFactory();
                    dummyFactory.setListenerFactory((InstallerFactory.StatusChangeListenerFactory)new StudioSdkInstallListenerFactory(this.mySdkHandler));
                    if (remote) {
                        Installer installer = dummyFactory.createInstaller((RemotePackage)pendingPackage, mgr, new StudioDownloader());
                        installer.complete((ProgressIndicator)progress2);
                    } else {
                        Uninstaller uninstaller = dummyFactory.createUninstaller(pendingPackage, mgr);
                        uninstaller.complete((ProgressIndicator)progress2);
                    }
                } else {
                    progress2.logWarning("Failed to find version information in " + androidSdkPath.resolve("source.properties"));
                    Files.move(oldPackageXml, existingPackageXml, new CopyOption[0]);
                }
            }
        }
        catch (Exception e) {
            StringBuilder message2 = new StringBuilder("A problem occurred while installing ");
            message2.append(pendingPackage != null ? pendingPackage.getDisplayName() : "an SDK package");
            if (installDir != null) {
                message2.append(" in ").append(installDir);
            }
            message2.append(". Please try again.");
            Messages.showErrorDialog((String)message2.toString(), (String)"Error Launching SDK Component Installer");
            progress2.logWarning("Failed to install SDK package", (Throwable)e);
        }
        try {
            PathUtils.deleteRecursivelyIfExists((Path)patchDir);
        }
        catch (IOException e) {
            progress2.logWarning("Problem during patch cleanup", (Throwable)e);
        }
    }

    private static class DummyInstallerFactory
    extends AbstractInstallerFactory {
        private DummyInstallerFactory() {
        }

        @NotNull
        protected Installer doCreateInstaller(@NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader) {
            return new AbstractInstaller(p, mgr, downloader){

                protected boolean doComplete(@Nullable Path installTemp, @NotNull ProgressIndicator progress2) {
                    return true;
                }

                protected boolean doPrepare(@NotNull Path installTempPath, @NotNull ProgressIndicator progress2) {
                    return false;
                }
            };
        }

        @NotNull
        protected Uninstaller doCreateUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr) {
            return new AbstractUninstaller(p, mgr){

                protected boolean doPrepare(@Nullable Path installTemp, ProgressIndicator progress2) {
                    return false;
                }

                protected boolean doComplete(@Nullable Path installTemp, ProgressIndicator progress2) {
                    return true;
                }
            };
        }
    }
}

