/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.io.CancellableFileIo;
import com.android.repository.api.Dependency;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallerUtil {
    public static final String PATCHER_PATH_PREFIX = "patcher";
    static final String PATCHES_DIR_NAME = ".patches";
    static final String PATCH_JAR_FN = "patch.jar";
    static final String PATCH_DIR_PREFIX = PatchInstallerFactory.class.getSimpleName();
    private static final String PATCH_ZIP_FN = "patch-file.zip";
    private static final String PATCHER_JAR_FN = "patcher.jar";

    @Nullable
    static LocalPackage getDependantPatcher(@NotNull RemotePackage remote, @NotNull RepoManager mgr) {
        for (Dependency d : remote.getAllDependencies()) {
            LocalPackage patcher;
            if (!d.getPath().startsWith("patcher;") || (patcher = (LocalPackage)mgr.getPackages().getLocalPackages().get(d.getPath())) == null) continue;
            return patcher;
        }
        return null;
    }

    @Nullable
    static LocalPackage getLatestPatcher(@NotNull RepoManager mgr) {
        LocalPackage patcher = null;
        for (LocalPackage p : mgr.getPackages().getLocalPackagesForPrefix(PATCHER_PATH_PREFIX)) {
            if (patcher != null && PatchInstallerUtil.comparePatcherPaths(p.getPath(), patcher.getPath()) <= 0) continue;
            patcher = p;
        }
        return patcher;
    }

    static int comparePatcherPaths(@NotNull String path1, @NotNull String path2) {
        int v1 = -1;
        int v2 = -1;
        try {
            v1 = Integer.parseInt(path1.substring(path1.lastIndexOf(118) + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            v2 = Integer.parseInt(path2.substring(path2.lastIndexOf(118) + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Integer.compare(v1, v2);
    }

    static boolean installPatch(@NotNull PatchOperation op, @Nullable Path patch, @NotNull ProgressIndicator progress2) {
        boolean result2;
        if (patch == null) {
            return false;
        }
        LocalPackage patcherPackage = op.getPatcher(progress2);
        if (patcherPackage == null) {
            return false;
        }
        PatchRunner patcher = new PatchRunner.DefaultFactory().getPatchRunner(patcherPackage, progress2);
        if (patcher == null) {
            return false;
        }
        try {
            PathUtils.deleteRecursivelyIfExists((Path)op.getLocation(progress2).resolve(".installer"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path tempPath = patch.getParent();
        Path existingPackageXml = op.getLocation(progress2).resolve("package.xml");
        Path tempPackageXml = tempPath.resolve("package.xml");
        try {
            Files.move(existingPackageXml, tempPackageXml, new CopyOption[0]);
        }
        catch (IOException e) {
            return false;
        }
        try {
            result2 = patcher.run(op.getLocation(progress2), patch, progress2);
        }
        catch (PatchRunner.RestartRequiredException e) {
            PatchInstallerUtil.askAboutRestart(PatchInstallerUtil.getPatcherFile(patcherPackage), op, patch, progress2);
            result2 = false;
        }
        if (!result2) {
            try {
                Files.move(tempPackageXml, existingPackageXml, new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        progress2.logInfo("Done");
        return true;
    }

    @Nullable
    static Path getPatcherFile(@Nullable LocalPackage patcherPackage) {
        Path patcherFile = patcherPackage == null ? null : patcherPackage.getLocation().resolve(PATCHER_JAR_FN);
        return patcherFile != null && CancellableFileIo.exists((Path)patcherFile, (LinkOption[])new LinkOption[0]) ? patcherFile : null;
    }

    private static void askAboutRestart(@NotNull Path patcherFile, @NotNull PatchOperation op, @NotNull Path patchFile, @NotNull ProgressIndicator progress2) {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.invokeLater(() -> {
            ApplicationNamesInfo names = ApplicationNamesInfo.getInstance();
            boolean restartable = application.isRestartCapable();
            String[] options2 = restartable ? new String[]{"Cancel", "Restart Later", "Restart Now"} : new String[]{"Cancel", String.format("Exit %s", names.getProductName())};
            String message2 = op.getExisting() != null ? String.format("%1$s is currently in use by %2$s and cannot be updated. Please restart to complete installation.", op.getExisting().getDisplayName(), names.getFullProductName()) : String.format("Some files in the destination are currently in use by %1$s. Please restart to complete installation.", names.getFullProductName());
            int result2 = Messages.showDialog((Project)null, (String)message2, (String)"Restart Required", (String[])options2, (int)(options2.length - 1), (Icon)AllIcons.General.QuestionDialog);
            if (result2 == 0) {
                progress2.logInfo("Cancelled");
            } else if (PatchInstallerUtil.setupPatchDir(patchFile, patcherFile, op.getPackage(), op.getRepoManager(), progress2)) {
                if (result2 == 1 && restartable) {
                    progress2.logInfo("Installation will continue after restart");
                } else {
                    application.exit(true, true);
                }
            }
        }, ModalityState.any());
    }

    private static boolean setupPatchDir(@NotNull Path patchFile, @NotNull Path patcherFile, @NotNull RepoPackage toInstallOrDelete, @NotNull RepoManager mgr, @NotNull ProgressIndicator progress2) {
        Path localPath = mgr.getLocalPath();
        Path patchesDir = (localPath == null ? patchFile.getFileSystem().getPath("", new String[0]) : localPath).resolve(PATCHES_DIR_NAME);
        try {
            Path patchDir;
            int i = 1;
            while (true) {
                if (!CancellableFileIo.exists((Path)(patchDir = patchesDir.resolve(PATCH_DIR_PREFIX + i)), (LinkOption[])new LinkOption[0])) break;
                ++i;
            }
            Files.createDirectories(patchDir, new FileAttribute[0]);
            Path completePatch = patchDir.resolve(PATCH_JAR_FN);
            FileUtils.copyFile((Path)patcherFile, (Path)completePatch);
            try (FileSystem completeFs = FileSystems.newFileSystem(URI.create("jar:" + completePatch.toUri()), new HashMap());
                 FileSystem patchFs = FileSystems.newFileSystem(URI.create("jar:" + patchFile.toUri()), new HashMap());){
                Files.copy(patchFs.getPath(PATCH_ZIP_FN, new String[0]), completeFs.getPath(PATCH_ZIP_FN, new String[0]), new CopyOption[0]);
            }
            InstallerUtil.writePendingPackageXml((RepoPackage)toInstallOrDelete, (Path)patchDir, (RepoManager)mgr, (ProgressIndicator)progress2);
        }
        catch (IOException e) {
            progress2.logWarning("Error while setting up patch.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static Path generatePatch(PatchOperation patchOp, Path destDir, ProgressIndicator progress2) {
        File newFilesRoot;
        LocalPackage patcher = patchOp.getPatcher(progress2.createSubProgress(0.1));
        progress2.setFraction(0.1);
        if (patcher == null) {
            return null;
        }
        PatchRunner runner2 = new PatchRunner.DefaultFactory().getPatchRunner(patcher, progress2);
        if (runner2 == null) {
            return null;
        }
        LocalPackage existing2 = patchOp.getExisting();
        Path existingRoot = existing2 == null ? null : existing2.getLocation();
        String existingDescription = existing2 == null ? "None" : existing2.getDisplayName() + " Version " + existing2.getVersion();
        String description2 = patchOp.getNewVersionName();
        Path destination = destDir.resolve(PATCH_JAR_FN);
        if (runner2.generatePatch(existingRoot == null ? null : existingRoot.toFile(), newFilesRoot = patchOp.getNewFilesRoot().toFile(), existingDescription, description2, destination.toFile(), progress2.createSubProgress(1.0))) {
            progress2.setFraction(1.0);
            return destination;
        }
        progress2.setFraction(1.0);
        return null;
    }

    @Nullable
    public static PackageOperation getInProgressDependantPatcherInstall(@NotNull RemotePackage remote, @NotNull RepoManager mgr) {
        Map remotePackages = mgr.getPackages().getRemotePackages();
        for (Dependency dependency : remote.getAllDependencies()) {
            PackageOperation inProgress;
            RemotePackage remotePatcher;
            if (!dependency.getPath().startsWith("patcher;") || (remotePatcher = (RemotePackage)remotePackages.get(dependency.getPath())) == null || (inProgress = mgr.getInProgressInstallOperation((RepoPackage)remotePatcher)) == null || inProgress.getInstallStatus() == PackageOperation.InstallStatus.FAILED) continue;
            return inProgress;
        }
        return null;
    }
}

