/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchInstaller
extends AbstractInstaller
implements PatchOperation {
    private static final String PATCH_JAR_FN = "patch.jar";
    private final LocalPackage myExisting;
    private Path myPatchFile;

    public PatchInstaller(@Nullable LocalPackage existing2, @NotNull RemotePackage p, @NotNull Downloader downloader, @NotNull RepoManager mgr) {
        super(p, mgr, downloader);
        this.myExisting = existing2;
    }

    protected boolean doComplete(@Nullable Path installTemp, @NotNull ProgressIndicator progress2) {
        if (this.myPatchFile == null) {
            this.myPatchFile = installTemp.resolve(PATCH_JAR_FN);
        }
        return PatchInstallerUtil.installPatch(this, this.myPatchFile, progress2);
    }

    protected boolean doPrepare(@NotNull Path tempDir, @NotNull ProgressIndicator progress2) {
        LocalPackage local = (LocalPackage)this.getRepoManager().getPackages().getLocalPackages().get(this.getPackage().getPath());
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        Archive.PatchType patch = archive.getPatch(local.getVersion());
        assert (patch != null);
        this.myPatchFile = this.downloadPatchFile(patch, tempDir, progress2);
        if (this.myPatchFile == null) {
            progress2.logWarning("Patch failed to download.");
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @Nullable
    public LocalPackage getPatcher(@NotNull ProgressIndicator progress2) {
        LocalPackage dependantPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
        if (dependantPatcher == null) {
            dependantPatcher = this.tryToCompletePatcherInstall(progress2);
        }
        if (dependantPatcher == null) {
            progress2.logWarning("Failed to find SDK Patch Applier!");
        }
        return dependantPatcher;
    }

    @Nullable
    private LocalPackage tryToCompletePatcherInstall(@NotNull ProgressIndicator progress2) {
        PackageOperation op = PatchInstallerUtil.getInProgressDependantPatcherInstall(this.getPackage(), this.getRepoManager());
        if (op != null && op.getInstallStatus() == PackageOperation.InstallStatus.PREPARED) {
            op.complete(progress2.createSubProgress(0.9));
            progress2.setFraction(0.9);
        }
        this.getRepoManager().reloadLocalIfNeeded(progress2.createSubProgress(1.0));
        progress2.setFraction(1.0);
        return PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
    }

    @Override
    @NotNull
    public Path getNewFilesRoot() {
        throw new UnsupportedOperationException("PatchInstaller can't generate patches");
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        return this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
    }

    @Nullable
    private Path downloadPatchFile(@NotNull Archive.PatchType patch, @NotNull Path tempDir, @NotNull ProgressIndicator progress2) {
        URL url = InstallerUtil.resolveUrl((String)patch.getUrl(), (RemotePackage)this.getPackage(), (ProgressIndicator)progress2);
        if (url == null) {
            progress2.logWarning("Failed to resolve URL: " + patch.getUrl());
            return null;
        }
        try {
            Path patchFile = tempDir.resolve(PATCH_JAR_FN);
            this.getDownloader().downloadFullyWithCaching(url, patchFile, patch.getTypedChecksum(), progress2);
            return patchFile;
        }
        catch (IOException e) {
            progress2.logWarning("Error during downloading", (Throwable)e);
            return null;
        }
    }
}

