/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.gradle.project.sync.setup.post.cleanup.SdksCleanupUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class VfsInstallListener
implements PackageOperation.StatusChangeListener {
    public void statusChanged(final PackageOperation op, final ProgressIndicator progress2) {
        if (op.getInstallStatus().equals((Object)PackageOperation.InstallStatus.COMPLETE)) {
            new Task.Backgroundable(null, "Refreshing...", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull com.intellij.openapi.progress.ProgressIndicator indicator) {
                    indicator.setIndeterminate(true);
                    VfsInstallListener.doRefresh(op, progress2);
                }
            }.queue();
        }
    }

    private static void doRefresh(PackageOperation op, ProgressIndicator progress2) {
        VirtualFile file2 = VfsUtil.findFile((Path)op.getLocation(progress2), (boolean)true);
        if (file2 != null) {
            file2.refresh(false, true);
        }
        RefreshQueue.getInstance().refresh(true, false, () -> {
            AndroidSdks androidSdks = AndroidSdks.getInstance();
            for (Sdk sdk : androidSdks.getAllAndroidSdks()) {
                SdksCleanupUtil.updateSdkIfNeeded(sdk, androidSdks);
            }
        }, new VirtualFile[0]);
    }
}

