/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jdks {
    @NotNull
    private static final Logger LOG = Logger.getInstance(Jdks.class);
    @NonNls
    public static final String DOWNLOAD_JDK_8_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html";
    @NotNull
    private final IdeInfo myIdeInfo;

    @NotNull
    public static Jdks getInstance() {
        return (Jdks)ApplicationManager.getApplication().getService(Jdks.class);
    }

    public Jdks() {
        this(IdeInfo.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    public Jdks(@NotNull IdeInfo ideInfo) {
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public JavaSdkVersion findVersion(@NotNull Path jdkRoot) {
        return Jdks.getVersion(jdkRoot.toString());
    }

    @Nullable
    private static JavaSdkVersion getVersion(@NotNull String jdkRoot) {
        String version2 = JavaSdk.getInstance().getVersionString(jdkRoot);
        return StringUtil.isEmpty((String)version2) ? null : JavaSdkVersion.fromVersionString((String)version2);
    }

    @Nullable
    public Sdk createJdk(@NotNull String jdkHomePath) {
        Sdk jdk = (Sdk)ExternalSystemApiUtil.executeOnEdt(() -> SdkConfigurationUtil.createAndAddSDK((String)jdkHomePath, (SdkType)JavaSdk.getInstance()));
        if (jdk == null) {
            String msg = String.format("Unable to create JDK from path '%1$s'", jdkHomePath);
            LOG.error(msg);
        }
        return jdk;
    }

    @Nullable
    public Sdk createEmbeddedJdk() {
        if (this.myIdeInfo.isAndroidStudio()) {
            Path path2 = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (path2 == null) {
                return null;
            }
            Sdk jdk = this.createJdk(path2.toString());
            assert (jdk != null);
            return jdk;
        }
        return null;
    }

    public static boolean isJdkRunnableOnPlatform(@NotNull Sdk jdk) {
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (!SystemInfo.isWindows || !CpuArch.is32Bit()) {
            return true;
        }
        JavaSdk javaSdk = (JavaSdk)jdk.getSdkType();
        String javaExecutablePath = javaSdk.getVMExecutablePath(jdk);
        return Jdks.runAndCheckJVM(javaExecutablePath);
    }

    public static boolean isJdkRunnableOnPlatform(@NotNull String jdkHome) {
        return Jdks.runAndCheckJVM(FileUtil.join((String[])new String[]{jdkHome, "bin", "java"}));
    }

    private static boolean runAndCheckJVM(@NotNull String javaExecutablePath) {
        LOG.info("Checking java binary: " + javaExecutablePath);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{javaExecutablePath});
        commandLine.addParameter("-version");
        try {
            CapturingAnsiEscapesAwareProcessHandler process2 = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            int exitCode2 = process2.runProcess().getExitCode();
            return exitCode2 == 0;
        }
        catch (ExecutionException e) {
            LOG.info("Could not invoke 'java -version'", (Throwable)e);
            return false;
        }
    }
}

