/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.NonStaticAuthenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAuthenticator
extends NonStaticAuthenticator {
    @Nullable
    public PasswordAuthentication getPasswordAuthentication() {
        String host;
        PasswordAuthentication result2;
        URL url = this.getRequestingURL();
        if (url != null && (result2 = AndroidAuthenticator.getAuthentication(host = url.toString())) != null) {
            return result2;
        }
        return AndroidAuthenticator.getAuthentication(CommonProxy.getHostNameReliably((String)this.getRequestingHost(), (InetAddress)this.getRequestingSite(), (URL)this.getRequestingURL()));
    }

    public static String getCredentialServiceName(@NotNull String host) {
        return "AndroidSdk:" + host;
    }

    @Nullable
    public static PasswordAuthentication getAuthentication(@NotNull String host) {
        OneTimeString password;
        Credentials credentials = PasswordSafe.getInstance().get(new CredentialAttributes(AndroidAuthenticator.getCredentialServiceName(host)));
        if (credentials != null && (password = credentials.getPassword()) != null) {
            return new PasswordAuthentication(credentials.getUserName(), password.toCharArray());
        }
        return null;
    }
}

