/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import java.io.OutputStream;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalUnit;
import java.util.Random;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DateTimeGenerator
implements Function<OutputStream, Exception> {
    private final long myNow = System.currentTimeMillis();
    private final DateTimeFormatter myFormat;
    private final TemporalUnit myIncrements;
    private final int myIncrementStep;

    public DateTimeGenerator(@NotNull DateTimeFormatter format, int incrementStep, @NotNull TemporalUnit increments) {
        this.myFormat = format;
        this.myIncrementStep = incrementStep;
        this.myIncrements = increments;
    }

    public DateTimeGenerator(@NotNull DateTimeFormatter format, @NotNull TemporalUnit increments) {
        this(format, 1, increments);
    }

    @Override
    public Exception apply(OutputStream stream) {
        PrintStream printStream = new PrintStream(stream);
        Random random2 = new Random();
        long amount = random2.nextInt(200) * this.myIncrementStep;
        LocalDateTime time2 = LocalDateTime.now().minus(amount, this.myIncrements);
        for (int i = 0; i < 500; ++i) {
            printStream.println(time2.format(this.myFormat));
            time2 = time2.plus(random2.nextInt(10) * this.myIncrementStep, this.myIncrements);
        }
        return null;
    }
}

