/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.sdklib.AndroidVersion;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiUserUtils {
    public static final int PRIMARY_USERID = 0;

    public static boolean isCurrentUserThePrimaryUser(@NotNull IDevice device2, long timeout, TimeUnit units, boolean defaultValue) {
        if (device2.getVersion().getApiLevel() < AndroidVersion.SUPPORTS_MULTI_USER.getApiLevel()) {
            return false;
        }
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver2 = new CollectingOutputReceiver(latch);
        try {
            device2.executeShellCommand("am get-current-user", (IShellOutputReceiver)receiver2);
        }
        catch (Exception e) {
            return defaultValue;
        }
        try {
            latch.await(timeout, units);
        }
        catch (InterruptedException e) {
            Logger.getInstance(MultiUserUtils.class).warn("Timed out waiting for output from `am get-current-user`, returning " + defaultValue);
            return defaultValue;
        }
        Object output = receiver2.getOutput();
        try {
            return Integer.parseInt(((String)output).trim()) == 0;
        }
        catch (NumberFormatException e) {
            if (((String)output).length() > 40) {
                output = ((String)output).substring(0, 40) + "...";
            }
            Logger.getInstance(MultiUserUtils.class).warn("Error parsing output of `am get-current-user`: " + (String)output);
            return defaultValue;
        }
    }

    public static boolean hasMultipleUsers(@Nullable IDevice device2, long timeout, TimeUnit units, boolean defaultValue) {
        if (device2 == null) {
            return defaultValue;
        }
        if (device2.getVersion().getApiLevel() < AndroidVersion.SUPPORTS_MULTI_USER.getApiLevel()) {
            return false;
        }
        PmListUserReceiver receiver2 = new PmListUserReceiver();
        try {
            device2.executeShellCommand("pm list users", (IShellOutputReceiver)receiver2, timeout, units);
        }
        catch (Exception e) {
            Logger.getInstance(MultiUserUtils.class).warn("Timed out waiting for output from `pm list users`, returning " + defaultValue);
            return defaultValue;
        }
        return receiver2.getNumUsers() > 1;
    }

    public static int getUserIdFromAmParameters(@NotNull String amFlags) {
        String userFlag = "--user";
        int i = amFlags.indexOf(userFlag);
        if (i < 0) {
            return 0;
        }
        if ((i += userFlag.length() + 1) > amFlags.length()) {
            return 0;
        }
        amFlags = amFlags.substring(i).trim();
        try {
            return Integer.parseInt(amFlags);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @VisibleForTesting
    static final class PmListUserReceiver
    extends MultiLineReceiver {
        private int myNumUsers = 0;

        PmListUserReceiver() {
        }

        public void processNewLines(String[] lines2) {
            for (String line2 : lines2) {
                if (!line2.contains("UserInfo{")) continue;
                ++this.myNumUsers;
            }
        }

        public boolean isCancelled() {
            return false;
        }

        private int getNumUsers() {
            return this.myNumUsers;
        }
    }
}

