/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class LaunchUtils {
    private static final Pattern idKeyPattern = Pattern.compile("--user\\s+([0-9]+)");

    public static boolean canDebugAppOnDevice(@NotNull AndroidFacet facet2, @NotNull IDevice device2) {
        return LaunchUtils.canDebugApp(facet2) || LaunchUtils.isDebuggableDevice(device2);
    }

    public static boolean canDebugApp(@NotNull AndroidFacet facet2) {
        return ProjectSystemUtil.getModuleSystem(facet2).isDebuggable();
    }

    public static boolean isDebuggableDevice(@NotNull IDevice device2) {
        String buildType = device2.getProperty("ro.build.type");
        return "userdebug".equals(buildType) || "eng".equals(buildType);
    }

    @Slow
    @WorkerThread
    public static boolean isWatchFeatureRequired(@NotNull AndroidFacet facet2) {
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (AndroidFacet.getInstance((Module)facet2.getModule()) == null) {
            Logger.getInstance(LaunchUtils.class).warn("calling isWatchFeatureRequired when facet is not ready yet");
            return false;
        }
        try {
            MergedManifestSnapshot info2 = (MergedManifestSnapshot)MergedManifestManager.getMergedManifest(facet2.getModule()).get();
            Element usesFeatureElem = info2.findUsedFeature("android.hardware.type.watch");
            if (usesFeatureElem != null) {
                String required = usesFeatureElem.getAttributeNS("http://schemas.android.com/apk/res/android", "required");
                return StringUtil.isEmpty((String)required) || "true".equals(required);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getInstance(LaunchUtils.class).warn((Throwable)ex);
        }
        return false;
    }

    public static void initiateDismissKeyguard(@NotNull IDevice device2) {
        AndroidVersion canDismissKeyguard = new AndroidVersion(23, null);
        if (canDismissKeyguard.compareTo(device2.getVersion()) <= 0) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    device2.executeShellCommand("wm dismiss-keyguard", (IShellOutputReceiver)new NullOutputReceiver(), 10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    Logger.getInstance(LaunchUtils.class).warn("Unable to dismiss keyguard before launching activity");
                }
            });
        }
    }

    @Nullable
    public static Integer getUserIdFromFlags(@Nullable String flags) {
        if (flags == null) {
            return null;
        }
        Matcher m = idKeyPattern.matcher(flags);
        return m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
    }
}

