/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.tools.idea.gradle.util.GradleBuilds;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployAction
extends AnAction {
    @NotNull
    private final String myId;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final String myEnabledText;
    @NotNull
    private final String myEnabledDescription;

    protected DeployAction(@NotNull String id2, @NotNull Executor executor2, @NotNull String text2, @NotNull String description2) {
        super(text2, description2, null);
        this.myId = id2;
        this.myExecutor = executor2;
        this.myEnabledText = text2;
        this.myEnabledDescription = description2;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            DeployAction.disableAction(presentation, "Lack of Project", "Disabled due to lack of project");
            return;
        }
        if (!CommonAndroidUtil.getInstance().isAndroidProject(project)) {
            DeployAction.disableAction(presentation, "Not an Android Project", "Disabled since this Project is not an Android project.");
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(true);
        presentation.setText(this.myEnabledText);
        presentation.setDescription(this.myEnabledDescription);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (selectedConfiguration == null) {
            return;
        }
        RunConfiguration runConfiguration = selectedConfiguration.getConfiguration();
        DeployAction.rerun(project, this.myExecutor, runConfiguration, selectedConfiguration, e.getDataContext());
    }

    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    private static void disableAction(@NotNull Presentation presentation, @NotNull String text2, @NotNull String description2) {
        presentation.setVisible(false);
        presentation.setEnabled(false);
        presentation.setText(text2);
        presentation.setDescription(description2);
    }

    private static void rerun(@NotNull Project project, @NotNull Executor executor2, @Nullable RunConfiguration configuration, @Nullable RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
        if (configuration instanceof CompoundRunConfiguration) {
            RunManager runManager = RunManager.getInstance((Project)project);
            for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets()) {
                RunConfiguration subConfiguration = settingsAndEffectiveTarget.getConfiguration();
                DeployAction.rerun(project, executor2, subConfiguration, runManager.findSettings(subConfiguration), dataContext);
            }
        } else {
            ExecutionEnvironmentBuilder builder2;
            ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2 = settings == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)executor2, (RunnerAndConfigurationSettings)settings);
            if (builder2 == null) {
                return;
            }
            ExecutionEnvironment env = builder2.activeTarget().dataContext(dataContext).build();
            env.putUserData(GradleBuilds.BUILD_SHOULD_EXECUTE, (Object)false);
            ExecutionManager.getInstance((Project)project).restartRunProfile(env);
        }
    }

    public static final class DebugWithoutBuildAction
    extends DeployAction {
        public static final String ID = "android.deploy.DebugWithoutBuild";

        public DebugWithoutBuildAction() {
            super(ID, DefaultDebugExecutor.getDebugExecutorInstance(), "Debug Without Build", "Deploys and debugs the application without building.");
        }
    }

    public static final class RunWithoutBuildAction
    extends DeployAction {
        public static final String ID = "android.deploy.RunWithoutBuild";

        public RunWithoutBuildAction() {
            super(ID, DefaultRunExecutor.getRunExecutorInstance(), "Run Without Build", "Deploys and runs the application without building.");
        }
    }
}

