/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.execution.common.AndroidExecutionException;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0002J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/run/tasks/SandboxSdkLaunchTask;", "Lcom/android/tools/idea/run/tasks/AppLaunchTask;", "clientAppPackage", "", "(Ljava/lang/String;)V", "getCommand", "getDescription", "getDuration", "", "getId", "run", "", "launchContext", "Lcom/android/tools/idea/run/tasks/LaunchContext;", "Companion", "intellij.android.core"})
public final class SandboxSdkLaunchTask
extends AppLaunchTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String clientAppPackage;
    @NotNull
    public static final String SANDBOX_IS_DISABLED = "(.*)SDK sandbox is disabled(.*)";
    @NotNull
    public static final String PACKAGE_NOT_FOUND = "(.*)No such package [^ ]+ for user [0-9]+(.*)";
    @NotNull
    private static final String ID = "SANDBOX_SDK";
    @NotNull
    private static final Map<String, Pattern> errorPatterns;

    public SandboxSdkLaunchTask(@NotNull String clientAppPackage) {
        Intrinsics.checkNotNullParameter((Object)clientAppPackage, (String)"clientAppPackage");
        this.clientAppPackage = clientAppPackage;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching Sandbox SDK process";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    public void run(@NotNull LaunchContext launchContext) {
        Intrinsics.checkNotNullParameter((Object)launchContext, (String)"launchContext");
        IDevice iDevice = launchContext.getDevice();
        Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"launchContext.device");
        IDevice device2 = iDevice;
        CollectingOutputReceiver collectingOutputReceiver = new CollectingOutputReceiver();
        device2.executeShellCommand(this.getCommand(), (IShellOutputReceiver)collectingOutputReceiver);
        for (Map.Entry<String, Pattern> pattern : errorPatterns.entrySet()) {
            Matcher matcher = pattern.getValue().matcher(collectingOutputReceiver.getOutput());
            if (!matcher.find()) continue;
            throw new AndroidExecutionException(pattern.getKey(), matcher.group());
        }
    }

    private final String getCommand() {
        return "cmd sdk_sandbox start " + this.clientAppPackage;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SANDBOX_IS_DISABLED, (Object)Pattern.compile(SANDBOX_IS_DISABLED)), TuplesKt.to((Object)PACKAGE_NOT_FOUND, (Object)Pattern.compile(PACKAGE_NOT_FOUND))};
        errorPatterns = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/run/tasks/SandboxSdkLaunchTask$Companion;", "", "()V", "ID", "", "PACKAGE_NOT_FOUND", "SANDBOX_IS_DISABLED", "errorPatterns", "", "Ljava/util/regex/Pattern;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

