/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.instantapp.InstantAppSdks;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.google.android.instantapps.sdk.api.ExtendedSdk;
import com.google.android.instantapps.sdk.api.HandlerResult;
import com.google.android.instantapps.sdk.api.ProgressIndicator;
import com.google.android.instantapps.sdk.api.ResultStream;
import com.google.android.instantapps.sdk.api.StatusCode;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RunInstantAppTask
implements LaunchTask {
    private static final String ID = "RUN_INSTANT_APP";
    @NotNull
    private final Collection<ApkInfo> myPackages;
    @Nullable
    private final String myDeepLink;
    @NotNull
    private final InstantAppSdks mySdk;
    @NotNull
    private final List<String> myDisabledFeatures;

    public RunInstantAppTask(@NotNull Collection<ApkInfo> packages, @Nullable String link2, @NotNull List<String> disabledFeatures) {
        this.myPackages = packages;
        this.myDeepLink = link2;
        this.mySdk = InstantAppSdks.getInstance();
        this.myDisabledFeatures = disabledFeatures;
    }

    public RunInstantAppTask(@NotNull Collection<ApkInfo> packages, @Nullable String link2) {
        this(packages, link2, (List<String>)ImmutableList.of());
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Uploading and launching Instant App";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public void run(@NotNull LaunchContext launchContext) throws ExecutionException {
        final ConsoleView console = launchContext.getConsoleView();
        if (this.myPackages.size() != 1) {
            throw new ExecutionException(this.getDescription() + ": Package not found or not unique");
        }
        URL url = null;
        if (this.myDeepLink != null && !this.myDeepLink.isEmpty()) {
            try {
                url = new URL(this.myDeepLink);
            }
            catch (MalformedURLException e) {
                throw new ExecutionException(this.getDescription() + ": Invalid launch URL: " + this.myDeepLink);
            }
        }
        ResultStream resultStream = new ResultStream(){

            public void write(HandlerResult result2) {
                if (result2.isError()) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showWarningDialog((String)result2.getDetail(), (String)"Instant App Deployment Failed"));
                    ExecutionUtils.println(console, result2.toString());
                    RunInstantAppTask.getLogger().warn((Throwable)new RunInstantAppException(result2.getMessage()));
                } else {
                    ExecutionUtils.println(console, result2.toString());
                }
            }
        };
        IDevice device2 = launchContext.getDevice();
        ExtendedSdk aiaSdk = this.mySdk.loadLibrary();
        ApkInfo apkInfo = this.myPackages.iterator().next();
        List<ApkFileUnit> artifactFiles = apkInfo.getFiles();
        StatusCode status2 = RunInstantAppTask.isSingleZipFile(artifactFiles) ? aiaSdk.getRunHandler().runZip(artifactFiles.get(0).getApkFile(), url, AndroidDebugBridge.getSocketAddress(), device2.getSerialNumber(), null, resultStream, (ProgressIndicator)new NullProgressIndicator()) : aiaSdk.getRunHandler().runApks((ImmutableList)artifactFiles.stream().filter(apkFileUnit -> DynamicAppUtils.isFeatureEnabled(this.myDisabledFeatures, apkFileUnit)).map(ApkFileUnit::getApkFile).collect(ImmutableList.toImmutableList()), url, AndroidDebugBridge.getSocketAddress(), device2.getSerialNumber(), null, resultStream, (ProgressIndicator)new NullProgressIndicator());
        if (status2 != StatusCode.SUCCESS) {
            throw new ExecutionException("Instant app deployment failed");
        }
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(RunInstantAppTask.class);
    }

    private static boolean isSingleZipFile(List<ApkFileUnit> artifactFiles) {
        return artifactFiles.size() == 1 && StringUtil.toLowerCase((String)artifactFiles.get(0).getApkFile().getName()).endsWith(".zip");
    }

    @TestOnly
    @NotNull
    public Collection<ApkInfo> getPackages() {
        return this.myPackages;
    }

    private static class NullProgressIndicator
    implements ProgressIndicator {
        private NullProgressIndicator() {
        }

        public void setProgress(double v) {
        }
    }

    public static class RunInstantAppException
    extends Exception {
        private RunInstantAppException(@NotNull String message2) {
            super(message2);
        }

        private RunInstantAppException(@NotNull Throwable t) {
            super(t);
        }
    }
}

