/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.ApplicationTerminator;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessHandler;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillAndRestartAppLaunchTask
implements LaunchTask {
    private static final String ID = "KILL_APPLICATION";
    private final String myPackageName;

    public KillAndRestartAppLaunchTask(@NotNull String packageName2) {
        this.myPackageName = packageName2;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Killing application";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public boolean shouldRun(@NotNull LaunchContext launchContext) {
        return launchContext.getKillBeforeLaunch();
    }

    @Override
    public void run(@NotNull LaunchContext launchContext) throws ExecutionException {
        boolean terminateApp;
        ProcessHandler handler2 = launchContext.getProcessHandler();
        IDevice device2 = launchContext.getDevice();
        if (handler2 instanceof AndroidProcessHandler) {
            AndroidProcessHandler androidHandler = (AndroidProcessHandler)launchContext.getProcessHandler();
            terminateApp = !androidHandler.killClientAndRestartMonitor(device2);
        } else {
            handler2.destroyProcess();
            terminateApp = true;
        }
        if (!terminateApp) {
            return;
        }
        ApplicationTerminator appTerminator = new ApplicationTerminator(device2, this.myPackageName);
        if (!appTerminator.killApp()) {
            throw new ExecutionException("Fail to terminate app prior to restarting.");
        }
        if (!device2.isOnline() || !(handler2 instanceof AndroidProcessHandler)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                String id2;
                ActionManager manager = ActionManager.getInstance();
                if (DefaultRunExecutor.getRunExecutorInstance().getId().equals(launchContext.getEnv().getExecutor().getId())) {
                    id2 = "android.deploy.RunWithoutBuild";
                } else if (DefaultDebugExecutor.getDebugExecutorInstance().getId().equals(launchContext.getEnv().getExecutor().getId())) {
                    id2 = "android.deploy.DebugWithoutBuild";
                } else {
                    return;
                }
                AnAction action2 = manager.getAction(id2);
                if (action2 == null) {
                    return;
                }
                Project project = launchContext.getEnv().getProject();
                JComponent contextComponent = new JComponent(){};
                contextComponent.setVisible(true);
                contextComponent.setEnabled(true);
                contextComponent.addNotify();
                DataManager.registerDataProvider((JComponent)contextComponent, (DataProvider)new RerunDataProvider(project));
                manager.tryToExecute(action2, ActionCommand.getInputEvent((String)id2), (Component)contextComponent, "unknown", true);
            });
            throw new ExecutionException("Swap failed, need to rerun.");
        }
        ((AndroidProcessHandler)launchContext.getProcessHandler()).addTargetDevice(device2);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private static final class RerunDataProvider
    implements DataProvider {
        private final Project myProject;

        private RerunDataProvider(@NotNull Project project) {
            this.myProject = project;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            return null;
        }
    }
}

