/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.RunConfigurationNotifier;
import com.android.tools.idea.run.tasks.ClearAppStorageTaskKt;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/run/tasks/ClearAppStorageTask;", "Lcom/android/tools/idea/run/tasks/LaunchTask;", "packageName", "", "(Ljava/lang/String;)V", "getDescription", "getDuration", "", "getId", "run", "", "launchContext", "Lcom/android/tools/idea/run/tasks/LaunchContext;", "intellij.android.core"})
public final class ClearAppStorageTask
implements LaunchTask {
    @NotNull
    private final String packageName;

    public ClearAppStorageTask(@NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        this.packageName = packageName2;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = AndroidBundle.message("android.launch.task.clear.app.data.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.launch.\u2026ar.app.data.description\")");
        return string;
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    @NotNull
    public String getId() {
        return "CLEAR_APP_STORAGE_TASK";
    }

    @Override
    public void run(@NotNull LaunchContext launchContext) {
        String result2;
        Intrinsics.checkNotNullParameter((Object)launchContext, (String)"launchContext");
        IDevice iDevice = launchContext.getDevice();
        Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"launchContext.device");
        IDevice device2 = iDevice;
        String packageList = ClearAppStorageTaskKt.access$shellToString(device2, "pm list packages " + this.packageName);
        CharSequence charSequence = packageList;
        if (new Regex("^package:" + StringsKt.replace$default((String)this.packageName, (String)".", (String)"\\.", (boolean)false, (int)4, null) + "$").containsMatchIn(charSequence) && !Intrinsics.areEqual((Object)(result2 = ((Object)StringsKt.trim((CharSequence)ClearAppStorageTaskKt.access$shellToString(device2, "pm clear " + this.packageName))).toString()), (Object)"Success")) {
            Object[] objectArray = new Object[]{this.packageName, device2};
            String message2 = AndroidBundle.message("android.launch.task.clear.app.data.error", objectArray);
            Project project = launchContext.getEnv().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"launchContext.env.project");
            Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
            RunConfigurationNotifier.INSTANCE.notifyWarning(project, "", message2);
        }
    }
}

