/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ApplyChangesTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(ApplyChangesTask.class);
    private static final String ID = "APPLY_CHANGES";

    public ApplyChangesTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages, boolean rerunOnSwapFailure, boolean alwaysInstallWithPm) {
        super(project, packages, rerunOnSwapFailure, alwaysInstallWithPm);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Apply Changes";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Changes were not applied.";
    }

    @Override
    protected boolean shouldTaskLaunchApp() {
        return false;
    }

    @Override
    protected Deployer.Result perform(IDevice device2, Deployer deployer, @NotNull ApkInfo apkInfo, @NotNull Canceller canceller) throws DeployerException {
        LOG.info("Applying changes to application: " + apkInfo.getApplicationId());
        return deployer.fullSwap(ApplyChangesTask.getPathsToInstall(apkInfo), canceller);
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "Activity restarted. No code or resource changes detected.";
        }
        return "Activity restarted without re-installing the following APK(s): " + skippedApkList.stream().collect(Collectors.joining(", "));
    }
}

