/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class AndroidDeepLinkLaunchTask
extends AppLaunchTask {
    private static final String ID = "LAUNCH_DEEP_LINK";
    @NotNull
    private final String myDeepLink;
    @NotNull
    StartActivityFlagsProvider myStartActivityFlagsProvider;

    public AndroidDeepLinkLaunchTask(@NotNull String deepLink, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        this.myDeepLink = deepLink;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching URL";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public void run(@NotNull LaunchContext launchContext) throws ExecutionException {
        IDevice device2 = launchContext.getDevice();
        String text2 = "Launching deeplink: " + this.myDeepLink + ".\n";
        ConsoleView console = launchContext.getConsoleView();
        ExecutionUtils.println(console, "Launching deeplink: " + this.myDeepLink + ".\n");
        Logger.getInstance(this.getClass()).info(text2);
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.APP_INDEXING).setKind(AndroidStudioEvent.EventKind.APP_INDEXING_DEEP_LINK_LAUNCHED));
        ExecutionUtils.executeShellCommand(device2, "setprop log.tag.AppIndexApi VERBOSE", console, launchContext.getProgressIndicator());
        String command = AndroidDeepLinkLaunchTask.getLaunchDeepLinkCommand(this.myDeepLink, this.myStartActivityFlagsProvider.getFlags(device2));
        ExecutionUtils.executeShellCommand(device2, command, console, launchContext.getProgressIndicator());
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public static String getLaunchDeepLinkCommand(@NotNull String deepLink, @NotNull String extraFlags) {
        return "am start -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + AndroidDeepLinkLaunchTask.singleQuoteShell(deepLink) + (String)(extraFlags.isEmpty() ? "" : " " + extraFlags);
    }

    @NotNull
    private static String singleQuoteShell(@NotNull String literal) {
        return "'" + literal.replace("'", "'\\''") + "'";
    }
}

