/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.execution.common.AndroidExecutionException;
import com.android.tools.idea.run.activity.AndroidActivityLauncher;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActivityLaunchTask
extends AppLaunchTask {
    @VisibleForTesting
    static final String ACTIVITY_DOES_NOT_EXIST = "ACTIVITY_DOES_NOT_EXIST";
    @VisibleForTesting
    static final String UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY = "UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY";
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final StartActivityFlagsProvider myStartActivityFlagsProvider;
    private static final String ACTIVITY_DOES_NOT_EXIST_REGEX = "Activity class \\{[^}]*} does not exist";
    private static final Pattern activityDoesNotExistPattern = Pattern.compile("Activity class \\{[^}]*} does not exist");

    public ActivityLaunchTask(@NotNull String applicationId2, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        this.myApplicationId = applicationId2;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching activity";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @VisibleForTesting
    public String getStartActivityCommand(@NotNull IDevice device2, @NotNull ConsoleView consoleView) throws ExecutionException {
        String activityName = this.getQualifiedActivityName(device2, consoleView);
        if (activityName == null) {
            throw new AndroidExecutionException(UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY, "Unable to determine activity name");
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(this.myApplicationId, activityName);
        return AndroidActivityLauncher.getStartActivityCommand(activityPath, this.myStartActivityFlagsProvider.getFlags(device2));
    }

    @Nullable
    protected abstract String getQualifiedActivityName(@NotNull IDevice var1, @NotNull ConsoleView var2);

    @Override
    public void run(@NotNull LaunchContext launchContext) throws ExecutionException {
        ConsoleView console = launchContext.getConsoleView();
        IDevice device2 = launchContext.getDevice();
        String command = this.getStartActivityCommand(device2, console);
        CollectingOutputReceiver collectingOutputReceiver = new CollectingOutputReceiver();
        this.executeShellCommand(launchContext, console, device2, command, collectingOutputReceiver);
        Matcher matcher = activityDoesNotExistPattern.matcher(collectingOutputReceiver.getOutput());
        if (matcher.find()) {
            throw new AndroidExecutionException(ACTIVITY_DOES_NOT_EXIST, matcher.group());
        }
    }

    @VisibleForTesting
    protected void executeShellCommand(@NotNull LaunchContext launchContext, ConsoleView console, IDevice device2, String command, CollectingOutputReceiver collectingOutputReceiver) throws ExecutionException {
        ExecutionUtils.executeShellCommand(device2, command, console, (IShellOutputReceiver)collectingOutputReceiver, 15L, TimeUnit.SECONDS, launchContext.getProgressIndicator());
    }
}

