/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.ChangeType;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DeployerOption;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.UIService;
import com.android.tools.deployer.tasks.Canceller;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.IdeService;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.util.StudioPathManager;
import com.android.utils.ILogger;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApplyChangesAgentError;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDeployTask
implements LaunchTask {
    public static final int MIN_API_VERSION = 26;
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Deploy");
    private static final Map<StudioFlags.OptimisticInstallSupportLevel, EnumSet<ChangeType>> OPTIMISTIC_INSTALL_SUPPORT = ImmutableMap.of((Object)StudioFlags.OptimisticInstallSupportLevel.DISABLED, EnumSet.noneOf(ChangeType.class), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX, EnumSet.of(ChangeType.DEX), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX_AND_NATIVE, EnumSet.of(ChangeType.DEX, ChangeType.NATIVE_LIBRARY), (Object)StudioFlags.OptimisticInstallSupportLevel.DEX_AND_NATIVE_AND_RESOURCES, EnumSet.of(ChangeType.DEX, ChangeType.NATIVE_LIBRARY, ChangeType.RESOURCE));
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<ApkInfo> myPackages;
    @NotNull
    protected List<LaunchTaskDetail> mySubTaskDetails;
    protected final boolean myRerunOnSwapFailure;
    protected final boolean myAlwaysInstallWithPm;
    public static final Logger LOG = Logger.getInstance(AbstractDeployTask.class);

    public AbstractDeployTask(@NotNull Project project, @NotNull Collection<ApkInfo> packages, boolean rerunOnSwapFailure, boolean alwaysInstallWithPm) {
        this.myProject = project;
        this.myPackages = packages;
        this.myRerunOnSwapFailure = rerunOnSwapFailure;
        this.myAlwaysInstallWithPm = alwaysInstallWithPm;
        this.mySubTaskDetails = new ArrayList<LaunchTaskDetail>();
    }

    @Override
    public int getDuration() {
        return 20;
    }

    public List<Deployer.Result> run(IDevice device2, ProgressIndicator indicator) throws DeployerException {
        return this.doRun(device2, indicator);
    }

    @Override
    public void run(@NotNull LaunchContext launchContext) throws ExecutionException {
        IDevice device2 = launchContext.getDevice();
        Executor executor2 = launchContext.getEnv().getExecutor();
        try {
            launchContext.setLaunchApp(this.shouldTaskLaunchApp());
            List<Deployer.Result> results2 = this.doRun(device2, launchContext.getProgressIndicator());
            if (results2.stream().anyMatch(result2 -> result2.needsRestart)) {
                launchContext.setKillBeforeLaunch(true);
                launchContext.setLaunchApp(true);
            }
        }
        catch (DeployerException e) {
            this.suggestResolveAction(executor2, e);
            throw new ExecutionException((Throwable)e);
        }
    }

    private List<Deployer.Result> doRun(@NotNull IDevice device2, final ProgressIndicator indicator) throws DeployerException {
        Canceller canceller = new Canceller(){

            public boolean cancelled() {
                return indicator.isCanceled();
            }
        };
        LogWrapper logger2 = new LogWrapper(LOG);
        Stopwatch stopwatch = Stopwatch.createStarted();
        MetricsRecorder metrics = new MetricsRecorder();
        long vmClockStartNs = System.nanoTime();
        long wallClockStartMs = System.currentTimeMillis();
        AdbClient adb = new AdbClient(device2, (ILogger)logger2);
        AdbHelper.setAbbExecAllowed((boolean)((Boolean)StudioFlags.DDMLIB_ABB_EXEC_INSTALL_ENABLE.get()));
        AdbInstaller.Mode adbInstallerMode = AdbInstaller.Mode.DAEMON;
        if (!((Boolean)StudioFlags.APPLY_CHANGES_KEEP_CONNECTION_ALIVE.get()).booleanValue()) {
            adbInstallerMode = AdbInstaller.Mode.ONE_SHOT;
        }
        AdbInstaller installer = new AdbInstaller(this.getLocalInstaller(), adb, (Collection)metrics.getDeployMetrics(), (ILogger)logger2, adbInstallerMode);
        DeploymentService service = DeploymentService.getInstance(this.myProject);
        IdeService ideService = new IdeService(this.myProject);
        EnumSet<ChangeType> optimisticInstallSupport = EnumSet.noneOf(ChangeType.class);
        if (!this.myAlwaysInstallWithPm) {
            optimisticInstallSupport = OPTIMISTIC_INSTALL_SUPPORT.getOrDefault(StudioFlags.OPTIMISTIC_INSTALL_SUPPORT_LEVEL.get(), EnumSet.noneOf(ChangeType.class));
        }
        DeployerOption option = new DeployerOption.Builder().setUseOptimisticSwap(((Boolean)StudioFlags.APPLY_CHANGES_OPTIMISTIC_SWAP.get()).booleanValue()).setUseOptimisticResourceSwap(((Boolean)StudioFlags.APPLY_CHANGES_OPTIMISTIC_RESOURCE_SWAP.get()).booleanValue()).setOptimisticInstallSupport(optimisticInstallSupport).setUseStructuralRedefinition(((Boolean)StudioFlags.APPLY_CHANGES_STRUCTURAL_DEFINITION.get()).booleanValue()).setUseVariableReinitialization(((Boolean)StudioFlags.APPLY_CHANGES_VARIABLE_REINITIALIZATION.get()).booleanValue()).setFastRestartOnSwapFail(this.getFastRerunOnSwapFailure()).enableCoroutineDebugger(((Boolean)StudioFlags.COROUTINE_DEBUGGER_ENABLE.get()).booleanValue()).build();
        Deployer deployer = new Deployer(adb, service.getDeploymentCacheDatabase(), service.getDexDatabase(), service.getTaskRunner(), (Installer)installer, (UIService)ideService, metrics, (ILogger)logger2, option);
        ArrayList<String> idsSkippedInstall = new ArrayList<String>();
        ArrayList<Deployer.Result> results2 = new ArrayList<Deployer.Result>();
        for (ApkInfo apkInfo : this.myPackages) {
            Deployer.Result result2 = this.perform(device2, deployer, apkInfo, canceller);
            if (result2.skippedInstall) {
                idsSkippedInstall.add(apkInfo.getApplicationId());
            }
            results2.add(result2);
        }
        this.addSubTaskDetails(metrics.getDeployMetrics(), vmClockStartNs, wallClockStartMs);
        this.logAgentFailures(metrics.getAgentFailures());
        stopwatch.stop();
        long duration2 = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (idsSkippedInstall.isEmpty()) {
            String content2 = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration2));
            NOTIFICATION_GROUP.createNotification(content2, NotificationType.INFORMATION).notify(this.myProject);
        } else {
            String title = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration2));
            String content3 = this.createSkippedApkInstallMessage(idsSkippedInstall, idsSkippedInstall.size() == this.myPackages.size());
            NOTIFICATION_GROUP.createNotification(title, content3, NotificationType.INFORMATION).notify(this.myProject);
        }
        return results2;
    }

    protected abstract String getFailureTitle();

    protected abstract boolean shouldTaskLaunchApp();

    protected abstract Deployer.Result perform(IDevice var1, Deployer var2, @NotNull ApkInfo var3, @NotNull Canceller var4) throws DeployerException;

    private String getLocalInstaller() {
        Path path2 = StudioPathManager.isRunningFromSources() ? StudioPathManager.resolvePathFromSourcesRoot((String)"bazel-bin/tools/base/deploy/installer/android-installer") : Paths.get(PathManager.getHomePath(), "plugins/android/resources/installer");
        return path2.toString();
    }

    protected static List<String> getPathsToInstall(@NotNull ApkInfo apkInfo) {
        return apkInfo.getFiles().stream().map(ApkFileUnit::getApkPath).map(Path::toString).collect(Collectors.toList());
    }

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    final boolean getFastRerunOnSwapFailure() {
        return this.myRerunOnSwapFailure;
    }

    private void addSubTaskDetails(@NotNull Collection<DeployMetric> metrics, long startNanoTime, long startWallClockMs) {
        for (DeployMetric metric : metrics) {
            if (metric.getName().isEmpty()) continue;
            LaunchTaskDetail.Builder detail = LaunchTaskDetail.newBuilder();
            long startOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getStartTimeNs() - startNanoTime);
            long endOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getEndTimeNs() - startNanoTime);
            detail.setId(this.getId() + "." + metric.getName()).setStartTimestampMs(startWallClockMs + startOffsetMs).setEndTimestampMs(startWallClockMs + endOffsetMs).setTid((int)metric.getThreadId());
            if (metric.hasStatus()) {
                detail.setStatus(metric.getStatus());
            }
            this.mySubTaskDetails.add(detail.build());
        }
    }

    private void logAgentFailures(List<Deploy.AgentExceptionLog> agentExceptionLogs) {
        for (Deploy.AgentExceptionLog log : agentExceptionLogs) {
            UsageTracker.log((AndroidStudioEvent.Builder)AbstractDeployTask.toStudioEvent(log));
        }
    }

    private static AndroidStudioEvent.Builder toStudioEvent(Deploy.AgentExceptionLog log) {
        ApplyChangesAgentError.AgentPurpose purpose = ApplyChangesAgentError.AgentPurpose.forNumber((int)log.getAgentPurposeValue());
        ApplyChangesAgentError.Builder builder2 = ApplyChangesAgentError.newBuilder().setEventTimeMs(TimeUnit.MILLISECONDS.convert(log.getEventTimeNs(), TimeUnit.NANOSECONDS)).setAgentAttachTimeMs(TimeUnit.MILLISECONDS.convert(log.getAgentAttachTimeNs(), TimeUnit.NANOSECONDS)).setAgentAttachCount(log.getAgentAttachCount()).setAgentPurpose(purpose);
        log.getFailedClassesList().stream().map(ApplyChangesAgentError.TargetClass::valueOf).forEach(arg_0 -> ((ApplyChangesAgentError.Builder)builder2).addTargetClasses(arg_0));
        return AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.APPLY_CHANGES_AGENT_ERROR).setApplyChangesAgentError(builder2);
    }

    @Override
    @NotNull
    public Collection<LaunchTaskDetail> getSubTaskDetails() {
        return this.mySubTaskDetails;
    }

    public void suggestResolveAction(@NotNull Executor executor2, @NotNull DeployerException e) {
        LOG.warn(String.format("%s failed: %s %s", this.getDescription(), e.getMessage(), e.getDetails()));
        StringBuilder bubbleError = new StringBuilder(this.getFailureTitle());
        bubbleError.append("\n");
        bubbleError.append(e.getMessage());
        DeployerException.Error error = e.getError();
        String callToAction = error.getCallToAction();
        DeployerException.ResolutionAction resolutionAction = error.getResolution();
        if ("Debug".equals(executor2.getId()) && resolutionAction == DeployerException.ResolutionAction.APPLY_CHANGES) {
            callToAction = "Rerun";
            resolutionAction = DeployerException.ResolutionAction.RUN_APP;
        }
        if (resolutionAction == DeployerException.ResolutionAction.NONE) {
            NOTIFICATION_GROUP.createNotification(bubbleError.toString(), NotificationType.ERROR).notify(this.myProject);
            return;
        }
        AnAction action2 = ActionManager.getInstance().getAction(switch (resolutionAction) {
            case DeployerException.ResolutionAction.APPLY_CHANGES -> "android.deploy.ApplyChanges";
            case DeployerException.ResolutionAction.RUN_APP -> "Debug".equals(executor2.getId()) ? "Debug" : "Run";
            case DeployerException.ResolutionAction.RETRY -> executor2.getActionName();
            default -> throw new RuntimeException("Unknown resolution action");
        });
        Runnable actionRunnable = () -> ActionManager.getInstance().tryToExecute(action2, null, null, null, true);
        if (this.myRerunOnSwapFailure) {
            bubbleError.append(String.format("\n%s will be done automatically</a>", callToAction));
            NOTIFICATION_GROUP.createNotification(bubbleError.toString(), NotificationType.ERROR).notify(this.myProject);
            ApplicationManager.getApplication().invokeLater(actionRunnable);
        } else {
            NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)callToAction, (Runnable)actionRunnable);
            NOTIFICATION_GROUP.createNotification(bubbleError.toString(), NotificationType.ERROR).addAction((AnAction)notificationAction).notify(this.myProject);
        }
    }

    protected abstract String createSkippedApkInstallMessage(List<String> var1, boolean var2);

    @Override
    @NotNull
    public Collection<ApkInfo> getApkInfos() {
        return this.myPackages;
    }
}

