/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DynamicFeaturesParameters {
    private static final int PREFERRED_HEIGHT_IN_ROWS = 4;
    @NotNull
    private final DynamicFeaturesTableModel myTableModel;
    @NotNull
    private final Set<String> myDisabledDynamicFeatures;
    private JPanel myRootPanel;
    private JBScrollPane myTableScrollPane;
    private JBTable myTable;
    private JBLabel myAdditionalTextLabel;
    private JPanel myDependencyUndoPanel;
    private JLabel myDependencyUndoLabel;
    private LinkLabel myDependencyUndoLink;

    public DynamicFeaturesParameters() {
        this.$$$setupUI$$$();
        this.myTableModel = new DynamicFeaturesTableModel();
        this.myDisabledDynamicFeatures = new HashSet<String>();
        this.myAdditionalTextLabel.setForeground(NamedColorUtil.getInactiveTextColor());
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTable.setTableHeader(null);
        this.myTableScrollPane.setColumnHeaderView(null);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn checkMarkColumn = columnModel.getColumn(0);
        checkMarkColumn.setCellRenderer(new CheckBoxCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)0);
        columnModel.getColumn(1).setCellRenderer(new FeatureNameCellRenderer());
        columnModel.getColumn(2).setCellRenderer(new DependencyLabelCellRenderer());
        this.myDependencyUndoLabel.setIcon(AllIcons.General.BalloonInformation);
        this.myDependencyUndoLink.setIcon(null);
        this.myDependencyUndoPanel.setVisible(false);
        this.disable();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootPanel;
    }

    @TestOnly
    JTable getTableComponent() {
        return this.myTable;
    }

    @TestOnly
    JPanel getUndoPanel() {
        return this.myDependencyUndoPanel;
    }

    @TestOnly
    JLabel getUndoLabel() {
        return this.myDependencyUndoLabel;
    }

    @TestOnly
    LinkLabel getUndoLink() {
        return this.myDependencyUndoLink;
    }

    @NotNull
    public List<String> getDisabledDynamicFeatures() {
        return ImmutableList.copyOf(this.myDisabledDynamicFeatures);
    }

    public void setActiveModule(@Nullable Module module2, AvailableDeployTypes deployType) {
        this.setDisabledDynamicFeatures(new ArrayList<String>());
        if (module2 == null) {
            this.disable();
            return;
        }
        this.myTableModel.clear();
        this.addBaseModule(module2);
        List<Module> features = ProjectSystemUtil.getModuleSystem(module2).getDynamicFeatureModules();
        if (features.isEmpty()) {
            this.disable();
            return;
        }
        this.addFeatureList(features, deployType);
    }

    public void addFeatureList(@NotNull List<Module> features, AvailableDeployTypes deployType) {
        features.stream().sorted((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true)).map(f -> this.createRow((Module)f, deployType)).forEach(row2 -> this.myTableModel.addRow((DynamicFeatureRow)row2));
        this.enable();
    }

    @NotNull
    private DynamicFeatureRow createRow(@NotNull Module module2, AvailableDeployTypes deployType) {
        if (deployType == AvailableDeployTypes.INSTANT_AND_INSTALLED) {
            AndroidModel model2 = AndroidModel.get(module2);
            if (model2 != null && model2.isInstantAppCompatible()) {
                return new DynamicFeatureRow(module2, this.isFeatureEnabled(module2.getName()));
            }
            return new DynamicFeatureRow(module2, this.isFeatureEnabled(module2.getName()), true, FeatureType.NON_INSTANT_DYNAMIC_FEATURE);
        }
        return new DynamicFeatureRow(module2, this.isFeatureEnabled(module2.getName()));
    }

    public void addBaseModule(@NotNull Module module2) {
        if (((Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get()).booleanValue()) {
            AndroidModel model2 = AndroidModel.get(module2);
            if (model2 == null) {
                return;
            }
            Module baseFeature = DynamicAppUtils.getBaseFeature(module2);
            if (baseFeature != null || !model2.isBaseSplit()) {
                return;
            }
            baseFeature = module2;
            this.myTableModel.addRow(new DynamicFeatureRow(baseFeature, true, false, FeatureType.BASE_FEATURE));
        }
    }

    public void setDisabledDynamicFeatures(@NotNull List<String> disabledDynamicFeatures) {
        this.myDisabledDynamicFeatures.clear();
        this.myDisabledDynamicFeatures.addAll(disabledDynamicFeatures);
        this.myTableModel.myFeatures.forEach(x -> {
            x.isChecked = this.isFeatureEnabled(x.getFeatureName());
        });
        this.myTableModel.fireTableDataChanged();
    }

    public void updateBasedOnInstantState(@NotNull Module module2, boolean instantAppDeploy) {
        List<Module> features = DynamicAppUtils.getDependentInstantFeatureModules(module2);
        List featurenames = ContainerUtil.map(features, x -> x.getName());
        if (instantAppDeploy) {
            this.myTableModel.myFeatures.forEach(x -> {
                if (!featurenames.contains(x.getFeatureName()) && !x.isBaseFeature()) {
                    x.isChecked = false;
                    x.setEnabled(false);
                    this.myDisabledDynamicFeatures.add(x.getFeatureName());
                }
            });
        } else {
            this.myTableModel.myFeatures.forEach(x -> {
                if (!x.isBaseFeature()) {
                    x.setEnabled(true);
                }
            });
        }
        this.myTableModel.fireTableDataChanged();
    }

    private boolean isFeatureEnabled(@NotNull String name2) {
        return !this.myDisabledDynamicFeatures.contains(name2);
    }

    private void enable() {
        this.myTableModel.fireTableDataChanged();
        Insets insets = this.myTableScrollPane.getInsets();
        int minHeight = insets.top + this.myTable.getRowHeight() * 4 + insets.bottom;
        this.myTableScrollPane.setMinimumSize(new Dimension(200, minHeight));
        this.myRootPanel.setVisible(true);
    }

    private void disable() {
        this.myTableModel.clear();
        this.myTableModel.fireTableDataChanged();
        this.myRootPanel.setVisible(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LinkLabel linkLabel;
        JLabel jLabel;
        JPanel jPanel;
        JBTable jBTable;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, true, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Dynamic features to deploy:");
        jPanel3.add((Component)jBLabel2, "West");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "Center");
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0), null, 0, 0, null, null));
        this.myAdditionalTextLabel = jBLabel = new JBLabel();
        jBLabel.setText("(for devices that support dynamic features)");
        jPanel4.add((Component)jBLabel, "Center");
        this.myTableScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTable = jBTable = new JBTable();
        jBTable.setPreferredScrollableViewportSize(new Dimension(450, 115));
        jBScrollPane.setViewportView((Component)jBTable);
        this.myDependencyUndoPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 2, 5));
        ((Component)jPanel).setVisible(true);
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "", 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:d:grow", "center:d:noGrow"));
        Component component2 = jPanel.add(jPanel5);
        this.myDependencyUndoLabel = jLabel = new JLabel();
        jLabel.setIconTextGap(5);
        jLabel.setText("This is placeholder text describing dependencies");
        ((Component)jLabel).setVisible(true);
        jPanel5.add((Component)jLabel, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myDependencyUndoLink = linkLabel = new LinkLabel();
        linkLabel.setAlignmentX(0.0f);
        linkLabel.setDoubleBuffered(false);
        linkLabel.setEnabled(true);
        linkLabel.setFocusTraversalPolicyProvider(true);
        linkLabel.setInheritsPopupMenu(true);
        linkLabel.setText("Undo");
        jPanel5.add((Component)linkLabel, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class DynamicFeaturesTableModel
    extends AbstractTableModel {
        public static final int COLUMN_COUNT = 3;
        public static final int CHECK_MARK_COLUMN_INDEX = 0;
        public static final int FEATURE_NAME_COLUMN_INDEX = 1;
        public static final int DEPENDENCY_LABEL_COLUMN_INDEX = 2;
        private List<DynamicFeatureRow> myFeatures = new ArrayList<DynamicFeatureRow>();
        private Map<String, DynamicFeatureRow> rowsByName = new HashMap<String, DynamicFeatureRow>();
        private UndoHandler myUndoHandler = new UndoHandler();

        public DynamicFeaturesTableModel() {
            DynamicFeaturesParameters.this.myDependencyUndoLink.setListener((LinkListener)this.myUndoHandler, null);
        }

        public void clear() {
            this.myFeatures.clear();
        }

        public void addRow(@NotNull DynamicFeatureRow row2) {
            this.myFeatures.add(row2);
            this.rowsByName.put(row2.getFeatureName(), row2);
        }

        @Override
        public int getRowCount() {
            return this.myFeatures.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.myFeatures.get((int)rowIndex).isChecked;
            }
            if (columnIndex == 1) {
                return this.myFeatures.get(rowIndex).getFeatureName();
            }
            if (columnIndex == 2) {
                return this.myFeatures.get(rowIndex).getDependentFeatureLabel();
            }
            return null;
        }

        @Override
        public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
            DynamicFeatureRow row2 = this.myFeatures.get(rowIndex);
            if (columnIndex == 0) {
                boolean shouldEnable = aValue == null || (Boolean)aValue != false;
                this.myUndoHandler.clearUndo();
                if (shouldEnable) {
                    Set<DynamicFeatureRow> newRowsChecked = this.includeDynamicFeature(row2);
                    if (newRowsChecked.size() > 1) {
                        this.myUndoHandler.saveRowsSelected(row2.featureName, newRowsChecked);
                    }
                } else {
                    Set<DynamicFeatureRow> newRowsUnchecked = this.excludeDynamicFeature(row2);
                    if (newRowsUnchecked.size() > 1) {
                        this.myUndoHandler.saveRowsDeselected(row2.featureName, newRowsUnchecked);
                    }
                }
                this.fireAllRowsUpdated();
            } else {
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }

        private void fireAllRowsUpdated() {
            this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        }

        @NotNull
        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && this.myFeatures.get((int)rowIndex).isEnabled;
        }

        private Set<DynamicFeatureRow> includeDynamicFeature(DynamicFeatureRow row2) {
            HashSet<DynamicFeatureRow> resultSet = new HashSet<DynamicFeatureRow>();
            if (!row2.isChecked) {
                resultSet.add(row2);
            }
            row2.setChecked(true);
            DynamicFeaturesParameters.this.myDisabledDynamicFeatures.remove(row2.featureName);
            for (String depName : row2.dependencyFeatureNames) {
                resultSet.addAll(this.includeDynamicFeature(this.rowsByName.get(depName)));
            }
            return resultSet;
        }

        private Set<DynamicFeatureRow> excludeDynamicFeature(DynamicFeatureRow row2) {
            HashSet<DynamicFeatureRow> resultSet = new HashSet<DynamicFeatureRow>();
            if (row2.isChecked) {
                resultSet.add(row2);
            }
            row2.setChecked(false);
            DynamicFeaturesParameters.this.myDisabledDynamicFeatures.add(row2.featureName);
            for (String childName : row2.dependentFeatureNames) {
                resultSet.addAll(this.excludeDynamicFeature(this.rowsByName.get(childName)));
            }
            return resultSet;
        }

        private class UndoHandler
        implements LinkListener {
            private Set<DynamicFeatureRow> undoRows;

            private UndoHandler() {
            }

            void clearUndo() {
                this.undoRows = null;
                DynamicFeaturesParameters.this.myDependencyUndoPanel.setVisible(false);
            }

            void saveRowsSelected(String clickedFeatureName, Set<DynamicFeatureRow> selectedRows) {
                int additionalAffectedCount = selectedRows.size() - 1;
                if (additionalAffectedCount == 1) {
                    DynamicFeaturesParameters.this.myDependencyUndoLabel.setText(String.format(Locale.US, "1 module required by %s has been selected", clickedFeatureName));
                } else {
                    DynamicFeaturesParameters.this.myDependencyUndoLabel.setText(String.format(Locale.US, "%d modules required by %s have been selected", additionalAffectedCount, clickedFeatureName));
                }
                this.undoRows = selectedRows;
                DynamicFeaturesParameters.this.myDependencyUndoPanel.setVisible(true);
            }

            void saveRowsDeselected(String clickedFeatureName, Set<DynamicFeatureRow> deselectedRows) {
                int additionalAffectedCount = deselectedRows.size() - 1;
                if (additionalAffectedCount == 1) {
                    DynamicFeaturesParameters.this.myDependencyUndoLabel.setText(String.format(Locale.US, "1 module requiring %s has been deselected", clickedFeatureName));
                } else {
                    DynamicFeaturesParameters.this.myDependencyUndoLabel.setText(String.format(Locale.US, "%d modules requiring %s have been deselected", additionalAffectedCount, clickedFeatureName));
                }
                this.undoRows = deselectedRows;
                DynamicFeaturesParameters.this.myDependencyUndoPanel.setVisible(true);
            }

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                if (this.undoRows != null) {
                    for (DynamicFeatureRow row2 : this.undoRows) {
                        if (row2.isChecked) {
                            row2.isChecked = false;
                            DynamicFeaturesParameters.this.myDisabledDynamicFeatures.add(row2.featureName);
                        } else {
                            row2.isChecked = true;
                            DynamicFeaturesParameters.this.myDisabledDynamicFeatures.remove(row2.featureName);
                        }
                        DynamicFeaturesTableModel.this.fireAllRowsUpdated();
                    }
                    this.clearUndo();
                }
            }
        }
    }

    private class CheckBoxCellRenderer
    extends StripedRowCellRenderer {
        private final TableCellRenderer myDelegate;

        public CheckBoxCellRenderer(TableCellRenderer delegate2) {
            this.myDelegate = delegate2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Component component2 = this.myDelegate.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row2, column2);
            DynamicFeatureRow featureRow = DynamicFeaturesParameters.this.myTableModel.myFeatures.get(row2);
            component2.setEnabled(featureRow.isEnabled);
            return component2;
        }
    }

    @VisibleForTesting
    class FeatureNameCellRenderer
    extends StripedRowCellRenderer {
        FeatureNameCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table2.getSelectionBackground());
            Component component2 = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row2, column2);
            if (component2 instanceof JLabel) {
                ((JLabel)component2).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            DynamicFeatureRow featureRow = DynamicFeaturesParameters.this.myTableModel.myFeatures.get(row2);
            this.setText(featureRow.getDisplayName());
            component2.setEnabled(isSelected || featureRow.isEnabled);
            return component2;
        }
    }

    private class DependencyLabelCellRenderer
    extends StripedRowCellRenderer {
        private DependencyLabelCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table2.getSelectionBackground());
            Component component2 = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row2, column2);
            if (component2 instanceof JLabel) {
                ((JLabel)component2).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            DynamicFeatureRow featureRow = DynamicFeaturesParameters.this.myTableModel.myFeatures.get(row2);
            String dependentFeatureLabel = featureRow.getDependentFeatureLabel();
            if (dependentFeatureLabel != null) {
                this.setText(dependentFeatureLabel);
            }
            if (!isSelected) {
                this.setForeground(NamedColorUtil.getInactiveTextColor());
            }
            return component2;
        }
    }

    public static enum AvailableDeployTypes {
        INSTALLED_ONLY,
        INSTANT_AND_INSTALLED;

    }

    private static class DynamicFeatureRow {
        @NotNull
        private final Module module;
        public boolean isChecked;
        public boolean isEnabled;
        public FeatureType featureType;
        @NotNull
        private final String featureName;
        @NotNull
        private final ImmutableSet<String> dependentFeatureNames;
        @NotNull
        private final ImmutableSet<String> dependencyFeatureNames;

        public DynamicFeatureRow(@NotNull Module module2, boolean isChecked, boolean isEnabled2, FeatureType featureType) {
            this.module = module2;
            this.isChecked = isChecked;
            this.isEnabled = isEnabled2;
            this.featureType = featureType;
            this.featureName = module2.getName();
            if (featureType == FeatureType.BASE_FEATURE) {
                this.dependentFeatureNames = ImmutableSet.of();
                this.dependencyFeatureNames = ImmutableSet.of();
            } else {
                this.dependentFeatureNames = (ImmutableSet)DynamicAppUtils.getFeatureModulesDependingOnFeature(module2).stream().map(Module::getName).collect(ImmutableSet.toImmutableSet());
                this.dependencyFeatureNames = (ImmutableSet)DynamicAppUtils.getFeatureModuleDependenciesForFeature(module2).stream().map(Module::getName).collect(ImmutableSet.toImmutableSet());
            }
        }

        public DynamicFeatureRow(@NotNull Module module2, boolean isChecked) {
            this(module2, isChecked, true, FeatureType.DYNAMIC_FEATURE);
        }

        public void setEnabled(boolean enabled2) {
            this.isEnabled = enabled2;
        }

        public void setChecked(boolean checked) {
            this.isChecked = checked;
        }

        public String getDisplayName() {
            if (this.featureType == FeatureType.BASE_FEATURE) {
                return this.featureName + " (base)";
            }
            if (this.featureType == FeatureType.NON_INSTANT_DYNAMIC_FEATURE) {
                return this.featureName + " (not instant app enabled)";
            }
            return this.featureName;
        }

        @NotNull
        public Module getModule() {
            return this.module;
        }

        @NotNull
        public String getFeatureName() {
            return this.featureName;
        }

        @Nullable
        public String getDependentFeatureLabel() {
            if (this.dependentFeatureNames.isEmpty()) {
                return null;
            }
            return "Required by " + String.join((CharSequence)", ", this.dependentFeatureNames);
        }

        public boolean isBaseFeature() {
            return this.featureType == FeatureType.BASE_FEATURE;
        }
    }

    public static enum FeatureType {
        BASE_FEATURE,
        NON_INSTANT_DYNAMIC_FEATURE,
        DYNAMIC_FEATURE;

    }

    private static class StripedRowCellRenderer
    extends DefaultTableCellRenderer {
        private StripedRowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Component component2 = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row2, column2);
            if (!isSelected) {
                component2.setBackground(row2 % 2 == 0 ? UIUtil.getDecoratedRowColor() : UIUtil.getTableBackground());
            }
            return component2;
        }
    }
}

