/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.execution.common.debug.AndroidDebuggerContext;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebuggerPanel;
import com.android.tools.idea.run.editor.AndroidProfilersPanel;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeploymentTargetOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurationEditor<T extends AndroidRunConfigurationBase>
extends SettingsEditor<T>
implements PanelWithAnchor,
ActionListener {
    private JPanel myPanel;
    protected JBTabbedPane myTabbedPane;
    private JBLabel myModuleJBLabel;
    private ModulesComboBox myModulesComboBox;
    private JPanel myConfigurationSpecificPanel;
    private final DeploymentTargetOptions myDeploymentTargetOptions;
    private JCheckBox myClearLogCheckBox;
    private JCheckBox myShowLogcatCheckBox;
    private JCheckBox myEnableLayoutInspectionWithoutActivityRestart;
    private JEditorPane myActivityRestartDescription;
    private JComponent anchor;
    private final ConfigurationModuleSelector myModuleSelector;
    private ConfigurationSpecificEditor<T> myConfigurationSpecificEditor;
    private AndroidDebuggerPanel myAndroidDebuggerPanel;
    private final AndroidProfilersPanel myAndroidProfilersPanel;
    public static final String LAYOUT_INSPECTION_WITHOUT_ACTIVITY_RESTART = "Layout Inspection Without Activity Restart";

    public AndroidRunConfigurationEditor(Project project, Predicate<Module> moduleValidator, T config2, boolean showLogcatCheckbox, boolean isAndroidTest, Function<ConfigurationModuleSelector, ConfigurationSpecificEditor<T>> configurationSpecificEditorFactory) {
        this.$$$setupUI$$$();
        Disposer.register((Disposable)project, (Disposable)this);
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.myModulesComboBox, (Predicate)moduleValidator, (AndroidRunConfigurationBase)config2){
            final /* synthetic */ Predicate val$moduleValidator;
            final /* synthetic */ AndroidRunConfigurationBase val$config;
            {
                this.val$moduleValidator = predicate2;
                this.val$config = androidRunConfigurationBase;
                super(project, modulesComboBox);
            }

            public boolean isModuleAccepted(Module module2) {
                if (module2 == null || !super.isModuleAccepted(module2)) {
                    return false;
                }
                return this.val$moduleValidator.apply((Object)module2);
            }

            public JavaRunConfigurationModule getConfigurationModule() {
                AndroidRunConfigurationModule configurationModule = new AndroidRunConfigurationModule(this.getProject(), this.val$config.isTestConfiguration());
                configurationModule.setModule(this.getModule());
                return configurationModule;
            }
        };
        this.myModulesComboBox.addActionListener((ActionListener)this);
        List<DeployTargetProvider> providers = ((AndroidRunConfigurationBase)config2).getApplicableDeployTargetProviders();
        switch (providers.size()) {
            case 0: 
            case 1: {
                this.myDeploymentTargetOptions = null;
                break;
            }
            default: {
                this.myDeploymentTargetOptions = new DeploymentTargetOptions(providers, this, project);
                this.myDeploymentTargetOptions.addTo((Container)this.myTabbedPane.getComponentAt(0));
            }
        }
        AndroidDebuggerContext androidDebuggerContext = ((AndroidRunConfigurationBase)config2).getAndroidDebuggerContext();
        if (androidDebuggerContext.getAndroidDebuggers().size() > 1) {
            this.myAndroidDebuggerPanel = new AndroidDebuggerPanel((RunConfiguration)config2, androidDebuggerContext);
            this.myTabbedPane.add("Debugger", (Component)this.myAndroidDebuggerPanel.getComponent());
        }
        this.myAndroidProfilersPanel = new AndroidProfilersPanel(project, ((AndroidRunConfigurationBase)config2).getProfilerState());
        this.myTabbedPane.add("Profiling", (Component)this.myAndroidProfilersPanel.getComponent());
        this.myConfigurationSpecificEditor = configurationSpecificEditorFactory.apply(this.myModuleSelector);
        Disposer.register((Disposable)this, this.myConfigurationSpecificEditor);
        this.myConfigurationSpecificPanel.add(this.myConfigurationSpecificEditor.getComponent());
        this.myActivityRestartDescription.setBorder((Border)JBUI.Borders.emptyLeft((int)24));
        this.myActivityRestartDescription.setForeground(UIUtil.getContextHelpForeground());
        this.myActivityRestartDescription.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myShowLogcatCheckBox.setVisible(showLogcatCheckbox);
        this.checkValidationResults(((AndroidRunConfigurationBase)config2).validate(null));
    }

    private void checkValidationResults(@NotNull List<ValidationError> errors2) {
        if (errors2.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors2);
        if (ValidationError.Category.PROFILER.equals((Object)topError.getCategory())) {
            this.myTabbedPane.setSelectedComponent((Component)this.myAndroidProfilersPanel.getComponent());
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModuleJBLabel.setAnchor(anchor);
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        this.myModuleSelector.reset(configuration);
        if (this.myDeploymentTargetOptions != null) {
            this.myDeploymentTargetOptions.resetFrom((AndroidRunConfigurationBase)configuration);
        }
        this.myClearLogCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).CLEAR_LOGCAT);
        this.myShowLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).SHOW_LOGCAT_AUTOMATICALLY);
        this.myEnableLayoutInspectionWithoutActivityRestart.setSelected(((AndroidRunConfigurationBase)configuration).INSPECTION_WITHOUT_ACTIVITY_RESTART);
        this.myEnableLayoutInspectionWithoutActivityRestart.setName(LAYOUT_INSPECTION_WITHOUT_ACTIVITY_RESTART);
        this.myConfigurationSpecificEditor.resetFrom(configuration);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.resetFrom(((AndroidRunConfigurationBase)configuration).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.resetFrom(((AndroidRunConfigurationBase)configuration).getProfilerState());
    }

    protected void applyEditorTo(@NotNull T configuration) {
        this.myModuleSelector.applyTo(configuration);
        if (this.myDeploymentTargetOptions != null) {
            this.myDeploymentTargetOptions.applyTo((AndroidRunConfigurationBase)configuration);
        }
        ((AndroidRunConfigurationBase)configuration).CLEAR_LOGCAT = this.myClearLogCheckBox.isSelected();
        ((AndroidRunConfigurationBase)configuration).SHOW_LOGCAT_AUTOMATICALLY = this.myShowLogcatCheckBox.isSelected();
        ((AndroidRunConfigurationBase)configuration).INSPECTION_WITHOUT_ACTIVITY_RESTART = this.myEnableLayoutInspectionWithoutActivityRestart.isSelected();
        this.myConfigurationSpecificEditor.applyTo(configuration);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.applyTo(((AndroidRunConfigurationBase)configuration).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.applyTo(((AndroidRunConfigurationBase)configuration).getProfilerState());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.myPanel;
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    @NotNull
    JComboBox getModuleComboBox() {
        return this.myModulesComboBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myModulesComboBox && this.myConfigurationSpecificEditor instanceof ApplicationRunParameters) {
            ((ApplicationRunParameters)this.myConfigurationSpecificEditor).onModuleChanged();
        }
    }

    @Nullable
    @VisibleForTesting
    DeploymentTargetOptions getDeploymentTargetOptions() {
        return this.myDeploymentTargetOptions;
    }

    private void createUIComponents() {
        this.myActivityRestartDescription = SwingHelper.createHtmlViewer((boolean)true, null, (Color)UIUtil.getPanelBackground(), (Color)UIUtil.getContextHelpForeground());
        this.myActivityRestartDescription.setText("<html>Enabling this option sets a required global flag on the device at deploy time. This avoids having to later restart the activity in order to enable the flag when connecting to the Layout Inspector.<br/>An alternative is to activate \"Enable view attribute inspection\" in the developer options on the device. <a href=\"https://developer.android.com/r/studio-ui/layout-inspector-activity-restart\">Learn more</a><br/></html>");
        this.myActivityRestartDescription.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(46, 14), null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.general.tab.title"), null, jPanel3, null);
        this.myModuleJBLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jBLabel.setDisplayedMnemonic('M');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesComboBox = modulesComboBox = new ModulesComboBox();
        jPanel3.add((Component)modulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigurationSpecificPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.misc.tab.title"), null, jPanel4, null);
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Logcat", 0, 0, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClearLogCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.logcat.skip.content.label"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowLogcatCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show logcat automatically");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Layout Inspector Options", 0, 0, null, null));
        this.myEnableLayoutInspectionWithoutActivityRestart = jCheckBox = new JCheckBox();
        jCheckBox.setText("Connect to Layout Inspector without restarting activity");
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JEditorPane jEditorPane = this.myActivityRestartDescription;
        jPanel6.add((Component)jEditorPane, new GridConstraints(1, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        jBLabel.setLabelFor((Component)modulesComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

