/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.adtui.ui.ClickableLabel;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkListener;

public class AndroidProfilersPanel {
    private final Project myProject;
    private JPanel myDescription;
    private JTextPane myNativeMemoryRateProfilerDescription;
    private JCheckBox myAdvancedProfilingCheckBox;
    private ClickableLabel myAdvancedProfilingLabel;
    private JEditorPane myAdvancedProfilingDescription;
    private JCheckBox myStartupProfileCheckBox;
    private ClickableLabel myStartupProfileLabel;
    private LabeledComponent<JBTextField> myNativeMemoryProfilerSampleRate;
    private ComboBox<CpuProfilerConfig> myStartupCpuConfigsComboBox;
    private JTextPane myStartupCpuProfilerDescription;
    private JBRadioButton myCpuRecordingRadio;
    private JBRadioButton myMemoryRecordingRadio;

    public JComponent getComponent() {
        return this.myDescription;
    }

    public AndroidProfilersPanel(Project project, ProfilerState state2) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.addActionListenersToLabels();
        this.setUpStartupProfiling();
        this.resetFrom(state2);
    }

    void addActionListenersToLabels() {
        this.myAdvancedProfilingLabel.addActionListener(e -> {
            this.myAdvancedProfilingCheckBox.requestFocus();
            this.myAdvancedProfilingCheckBox.setSelected(!this.myAdvancedProfilingCheckBox.isSelected());
        });
        this.myStartupProfileLabel.addActionListener(e -> this.myStartupProfileCheckBox.setSelected(!this.myStartupProfileCheckBox.isSelected()));
    }

    private void setUpStartupProfiling() {
        this.myStartupProfileCheckBox.addItemListener(e -> {
            this.myCpuRecordingRadio.setEnabled(this.myStartupProfileCheckBox.isSelected());
            this.myMemoryRecordingRadio.setEnabled(this.myStartupProfileCheckBox.isSelected());
            this.myStartupCpuConfigsComboBox.setEnabled(this.myCpuRecordingRadio.isSelected() && this.myStartupProfileCheckBox.isSelected());
            this.myStartupProfileCheckBox.setSelected(this.myStartupProfileCheckBox.isSelected());
        });
        this.myCpuRecordingRadio.addItemListener(e -> {
            if (this.myCpuRecordingRadio.isSelected()) {
                this.myMemoryRecordingRadio.setSelected(false);
                this.myStartupCpuConfigsComboBox.setEnabled(this.myCpuRecordingRadio.isSelected());
            }
        });
        this.myMemoryRecordingRadio.addItemListener(e -> {
            if (this.myMemoryRecordingRadio.isSelected()) {
                this.myCpuRecordingRadio.setSelected(false);
                this.myStartupCpuConfigsComboBox.setEnabled(!this.myMemoryRecordingRadio.isSelected());
            }
        });
        this.myStartupCpuConfigsComboBox.setModel(new DefaultComboBoxModel<CpuProfilerConfig>(CpuProfilerConfigsState.getInstance(this.myProject).getConfigs().toArray(new CpuProfilerConfig[0])));
        this.myStartupCpuConfigsComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", CpuProfilerConfig::getName));
        this.myStartupCpuConfigsComboBox.setSelectedIndex(0);
    }

    public void resetFrom(ProfilerState state2) {
        boolean enabled2 = this.myAdvancedProfilingCheckBox.isEnabled();
        this.myAdvancedProfilingCheckBox.setSelected(enabled2 && state2.ADVANCED_PROFILING_ENABLED);
        ((JBTextField)this.myNativeMemoryProfilerSampleRate.getComponent()).setText(Integer.toString(state2.NATIVE_MEMORY_SAMPLE_RATE_BYTES));
        this.myNativeMemoryRateProfilerDescription.setBackground(this.myDescription.getBackground());
        this.myNativeMemoryRateProfilerDescription.setForeground(UIUtil.getContextHelpForeground());
        this.myNativeMemoryRateProfilerDescription.setFont((Font)JBFont.small());
        this.myStartupProfileCheckBox.setSelected(state2.STARTUP_PROFILING_ENABLED);
        this.myCpuRecordingRadio.setSelected(state2.STARTUP_CPU_PROFILING_ENABLED);
        this.myMemoryRecordingRadio.setSelected(state2.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED);
        this.myStartupCpuProfilerDescription.setBackground(this.myDescription.getBackground());
        this.myStartupCpuProfilerDescription.setForeground(UIUtil.getContextHelpForeground());
        this.myStartupCpuProfilerDescription.setFont((Font)JBFont.small());
        String name2 = state2.STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        CpuProfilerConfig config2 = CpuProfilerConfigsState.getInstance(this.myProject).getConfigByName(name2);
        if (config2 != null) {
            this.myStartupCpuConfigsComboBox.setSelectedItem((Object)config2);
        }
    }

    public void applyTo(ProfilerState state2) {
        state2.ADVANCED_PROFILING_ENABLED = this.myAdvancedProfilingCheckBox.isSelected();
        state2.STARTUP_CPU_PROFILING_ENABLED = this.myCpuRecordingRadio.isSelected();
        assert (this.myStartupCpuConfigsComboBox.getSelectedItem() instanceof CpuProfilerConfig);
        state2.STARTUP_CPU_PROFILING_CONFIGURATION_NAME = ((CpuProfilerConfig)this.myStartupCpuConfigsComboBox.getSelectedItem()).getName();
        state2.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED = this.myMemoryRecordingRadio.isSelected();
        state2.STARTUP_PROFILING_ENABLED = this.myStartupProfileCheckBox.isSelected();
        try {
            state2.NATIVE_MEMORY_SAMPLE_RATE_BYTES = Math.max(1, Integer.parseInt(((JBTextField)this.myNativeMemoryProfilerSampleRate.getComponent()).getText()));
        }
        catch (NumberFormatException ex) {
            state2.NATIVE_MEMORY_SAMPLE_RATE_BYTES = 2048;
        }
    }

    private void createUIComponents() {
        this.myAdvancedProfilingDescription = SwingHelper.createHtmlViewer((boolean)true, null, (Color)UIUtil.getPanelBackground(), (Color)UIUtil.getContextHelpForeground());
        this.myAdvancedProfilingDescription.setFont((Font)JBFont.small());
        this.myAdvancedProfilingDescription.setText("<html>Adds support for network payloads, the event timeline, allocated object count and garbage collection events on devices running API level < 26. May slightly increase build time due to compile-time instrumentation. Has no effect on devices running API level >= 26. <a href=\"https://developer.android.com/r/studio-ui/profiler/support-for-older-devices\">Learn more</a></html>");
        this.myAdvancedProfilingDescription.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        LabeledComponent labeledComponent;
        ComboBox comboBox2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        ClickableLabel clickableLabel;
        JCheckBox jCheckBox;
        JTextPane jTextPane2;
        ClickableLabel clickableLabel2;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myDescription = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myStartupProfileCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setHorizontalAlignment(4);
        jCheckBox2.setHorizontalTextPosition(4);
        jCheckBox2.setIconTextGap(0);
        jCheckBox2.setMargin(new Insets(1, 0, 0, 0));
        jCheckBox2.setText("");
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        JEditorPane jEditorPane = this.myAdvancedProfilingDescription;
        jEditorPane.setEditable(false);
        Font font = this.$$$getFont$$$(null, -1, -1, jEditorPane.getFont());
        if (font != null) {
            jEditorPane.setFont(font);
        }
        jPanel.add((Component)jEditorPane, new GridConstraints(6, 1, 1, 2, 0, 3, 6, 2, null, new Dimension(150, 50), null));
        this.myStartupProfileLabel = clickableLabel2 = new ClickableLabel();
        clickableLabel2.setMargin(new Insets(2, 14, 0, 14));
        clickableLabel2.setText("Start this recording on startup:");
        jPanel.add((Component)clickableLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 3, null, null, null));
        this.myNativeMemoryRateProfilerDescription = jTextPane2 = new JTextPane();
        jTextPane2.setAutoscrolls(false);
        jTextPane2.setDoubleBuffered(false);
        jTextPane2.setEditable(false);
        ((Component)jTextPane2).setEnabled(true);
        Font font2 = this.$$$getFont$$$(null, -1, -1, jTextPane2.getFont());
        if (font2 != null) {
            jTextPane2.setFont(font2);
        }
        jTextPane2.setMargin(new Insets(0, 3, 0, 3));
        jTextPane2.setText("Native memory sampling rate. This value when set will remain for both startup and non-startup recordings.");
        jPanel.add((Component)jTextPane2, new GridConstraints(1, 1, 1, 2, 0, 3, 1, 1, null, null, null));
        this.myAdvancedProfilingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setAlignmentX(1.0f);
        jCheckBox.setHorizontalAlignment(4);
        jCheckBox.setHorizontalTextPosition(4);
        jCheckBox.setIconTextGap(0);
        jCheckBox.setMargin(new Insets(1, 0, 0, 0));
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null));
        this.myAdvancedProfilingLabel = clickableLabel = new ClickableLabel();
        clickableLabel.setText("Enable additional support for older devices (API level < 26)");
        jPanel.add((Component)clickableLabel, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCpuRecordingRadio = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setEnabled(false);
        jBRadioButton2.setText("CPU activity (Requires API level >= 26)");
        jPanel2.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myMemoryRecordingRadio = jBRadioButton = new JBRadioButton();
        jBRadioButton.setEnabled(false);
        jBRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jBRadioButton.setText("Native memory activity (Requires API level >= 29)");
        jPanel2.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 1, 3, 3, null, null, null));
        this.myStartupCpuConfigsComboBox = comboBox2 = new ComboBox();
        comboBox2.setEnabled(false);
        jPanel2.add((Component)comboBox2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 3, null, new Dimension(350, -1), null));
        this.myNativeMemoryProfilerSampleRate = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent.setLabelInsets(new Insets(0, 6, 0, 0));
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Native memory sampling interval (bytes)");
        jPanel.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 3, 9, 1, 3, 3, null, null, null));
        this.myStartupCpuProfilerDescription = jTextPane = new JTextPane();
        jTextPane.setAutoscrolls(false);
        jTextPane.setDoubleBuffered(false);
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        Font font3 = this.$$$getFont$$$(null, -1, -1, jTextPane.getFont());
        if (font3 != null) {
            jTextPane.setFont(font3);
        }
        jTextPane.setMargin(new Insets(0, 3, 0, 3));
        jTextPane.setText("You must select Run > Profile from the main menu and deploy your app to a device");
        jPanel.add((Component)jTextPane, new GridConstraints(3, 1, 1, 1, 0, 3, 1, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myDescription;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

