/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit.desugaring;

import com.android.tools.idea.run.deployment.liveedit.LiveEditCompilerOutput;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0007j\u0002`\b2\u001a\u0010\u000e\u001a\u0016\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\tH\u0000\u00a2\u0006\u0002\b\u0016J\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u00062\n\u0010\u0017\u001a\u00060\u0007j\u0002`\bJ.\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\n\u0010\u0017\u001a\u00060\u0007j\u0002`\bH\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u00062\n\u0010\u0017\u001a\u00060\u0007j\u0002`\bR2\u0010\u0005\u001a&\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u000e\u001a&\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\t0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugarResponse;", "", "compilerOutput", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompilerOutput;", "(Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompilerOutput;)V", "apiToClasses", "", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/MinApiLevel;", "", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/ClassName;", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/ByteCode;", "classes", "getClasses", "()Ljava/util/Map;", "getCompilerOutput", "()Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompilerOutput;", "addOutputSet", "", "minApiLevel", "addOutputSet$intellij_android_core", "apiLevel", "classNames", "", "groupIds", "", "resetState", "", "supportClasses", "intellij.android.core"})
public final class LiveEditDesugarResponse {
    @NotNull
    private final LiveEditCompilerOutput compilerOutput;
    @NotNull
    private final Map<Integer, Map<String, byte[]>> apiToClasses;

    public LiveEditDesugarResponse(@NotNull LiveEditCompilerOutput compilerOutput) {
        Intrinsics.checkNotNullParameter((Object)compilerOutput, (String)"compilerOutput");
        this.compilerOutput = compilerOutput;
        this.apiToClasses = new LinkedHashMap();
    }

    @NotNull
    public final LiveEditCompilerOutput getCompilerOutput() {
        return this.compilerOutput;
    }

    @NotNull
    public final Map<Integer, Map<String, byte[]>> getClasses() {
        return this.apiToClasses;
    }

    public final void addOutputSet$intellij_android_core(int minApiLevel, @NotNull Map<String, byte[]> classes2) {
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        Integer n = minApiLevel;
        this.apiToClasses.put(n, classes2);
    }

    public final boolean resetState() {
        return this.compilerOutput.getResetState();
    }

    @NotNull
    public final List<Integer> groupIds() {
        return this.compilerOutput.getGroupIds();
    }

    private final Map<String, byte[]> getClasses(Set<String> classNames, int apiLevel) {
        if (!this.apiToClasses.containsKey(apiLevel)) {
            LiveEditUpdateException.Companion.desugarFailure("No desugared classes for api=" + apiLevel);
        }
        Map classes2 = new HashMap();
        for (String className : classNames) {
            Map<String, byte[]> map2 = this.apiToClasses.get(apiLevel);
            Intrinsics.checkNotNull(map2);
            if (!map2.containsKey(className)) {
                LiveEditUpdateException.Companion.desugarFailure("Desugared classes api " + apiLevel + " does not contain " + className);
            }
            Map<String, byte[]> map3 = this.apiToClasses.get(apiLevel);
            Intrinsics.checkNotNull(map3);
            byte[] byArray = map3.get(className);
            Intrinsics.checkNotNull((Object)byArray);
            classes2.put(className, byArray);
        }
        return classes2;
    }

    @NotNull
    public final Map<String, byte[]> classes(int apiLevel) {
        return this.getClasses(this.compilerOutput.getClassesMap().keySet(), apiLevel);
    }

    @NotNull
    public final Map<String, byte[]> supportClasses(int apiLevel) {
        return this.getClasses(this.compilerOutput.getSupportClassesMap().keySet(), apiLevel);
    }
}

