/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit.desugaring;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompiledClass;
import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.desugaring.JarResourceCacheManager;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarRequest;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarResponse;
import com.android.tools.idea.run.deployment.liveedit.desugaring.R8DiagnosticHandler;
import com.android.tools.idea.run.deployment.liveedit.desugaring.R8MemoryClassFileConsumer;
import com.android.tools.idea.run.deployment.liveedit.desugaring.R8MemoryProgramResourceProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResourceProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ6\u0010\u000e\u001a\u0016\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\b\u0012\u00060\u0012j\u0002`\u00130\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002J6\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0018j\u0002`\u0019H\u0002J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugar;", "Ljava/lang/AutoCloseable;", "()V", "jarResourceCacheManager", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/JarResourceCacheManager;", "logger", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "close", "", "desugar", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugarResponse;", "request", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugarRequest;", "desugar$intellij_android_core", "desugarClasses", "", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/ClassName;", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/ByteCode;", "classes", "", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompiledClass;", "version", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/MinApiLevel;", "desugarClassesForModule", "module", "Lcom/intellij/openapi/module/Module;", "minApiLevel", "getAndroidJar", "Lcom/android/tools/r8/ClassFileResourceProvider;", "getClassPathResourceProvider", "getDesugarConfig", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditDesugarer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditDesugarer.kt\ncom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,216:1\n1851#2:217\n1549#2:218\n1620#2,3:219\n1852#2:222\n1549#2:223\n1620#2,3:224\n1603#2,9:227\n1851#2:236\n1852#2:238\n1612#2:239\n1851#2,2:240\n1851#2,2:244\n1851#2,2:246\n1#3:237\n211#4,2:242\n*S KotlinDebug\n*F\n+ 1 LiveEditDesugarer.kt\ncom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugar\n*L\n46#1:217\n47#1:218\n47#1:219,3\n46#1:222\n96#1:223\n96#1:224,3\n105#1:227,9\n105#1:236\n105#1:238\n105#1:239\n123#1:240,2\n171#1:244,2\n176#1:246,2\n105#1:237\n138#1:242,2\n*E\n"})
public final class LiveEditDesugar
implements AutoCloseable {
    @NotNull
    private final LiveEditLogger logger = new LiveEditLogger("LE Desugar");
    @NotNull
    private final JarResourceCacheManager jarResourceCacheManager = new JarResourceCacheManager(this.logger);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final LiveEditDesugarResponse desugar$intellij_android_core(@NotNull LiveEditDesugarRequest request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        long now = System.nanoTime();
        LiveEditDesugarResponse response2 = new LiveEditDesugarResponse(request2.getCompilerOutput());
        if (!((Boolean)StudioFlags.COMPOSE_DEPLOY_LIVE_EDIT_R8_DESUGAR.get()).booleanValue()) {
            Iterable $this$forEach$iv = request2.getApiVersions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<Pair> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int apiVersion = ((Number)element$iv).intValue();
                boolean bl = false;
                Iterable iterable = request2.getCompilerOutput().getClasses();
                int n = apiVersion;
                LiveEditDesugarResponse liveEditDesugarResponse = response2;
                boolean $i$f$map = false;
                void var15_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LiveEditCompiledClass liveEditCompiledClass = (LiveEditCompiledClass)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to((Object)it.getName(), (Object)it.getData()));
                }
                collection2 = (List)destination$iv$iv;
                liveEditDesugarResponse.addOutputSet$intellij_android_core(n, MapsKt.toMap((Iterable)collection2));
            }
            return response2;
        }
        try {
            Iterator<Integer> $this$forEach$iv = request2.getApiVersions().iterator();
            while ($this$forEach$iv.hasNext()) {
                int apiVersion = ((Number)$this$forEach$iv.next()).intValue();
                Map<String, byte[]> desugaredClasses = this.desugarClasses(request2.getCompilerOutput().getClasses(), apiVersion);
                response2.addOutputSet$intellij_android_core(apiVersion, desugaredClasses);
            }
        }
        finally {
            this.jarResourceCacheManager.done();
        }
        long durationMs = (System.nanoTime() - now) / (long)1000000;
        this.logger.log$intellij_android_core("Runtime = " + durationMs);
        return response2;
    }

    private final String getDesugarConfig(Module module2) {
        if (module2 == null) {
            this.logger.log$intellij_android_core("Cannot retrieve desugar config (no module)");
            return null;
        }
        List<Path> jsonConfigs = ProjectSystemUtil.getModuleSystem(module2).getDesugarLibraryConfigFiles();
        if (jsonConfigs.isEmpty()) {
            this.logger.log$intellij_android_core("Not Library Config from Build System");
            return null;
        }
        Path path2 = jsonConfigs.get(0);
        byte[] byArray = Files.readAllBytes(path2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(path)");
        byte[] byArray2 = byArray;
        String config2 = new String(byArray2, Charsets.UTF_8);
        this.logger.log$intellij_android_core("Library Config = " + path2);
        return config2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassFileResourceProvider> getAndroidJar(Module module2) {
        void $this$mapTo$iv$iv;
        if (module2 == null) {
            this.logger.log$intellij_android_core("Cannot retrieve android.jar (no module)");
            return CollectionsKt.emptyList();
        }
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        Collection<String> strings = ProjectSystemUtil.getProjectSystem(project).getBootClasspath(module2);
        this.logger.log$intellij_android_core("Android.jar = " + strings);
        Iterable $this$map$iv = strings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Path path2 = Paths.get((String)it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(it)");
            collection2.add(this.jarResourceCacheManager.getResourceCache$intellij_android_core(path2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassFileResourceProvider> getClassPathResourceProvider(Module module2) {
        void $this$mapNotNullTo$iv$iv;
        if (module2 == null) {
            LiveEditUpdateException.Companion.desugarFailure("Cannot retrieve classpath (no module)");
        }
        Module module3 = module2;
        Intrinsics.checkNotNull((Object)module3);
        Project project = module3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module!!.project");
        List<File> list2 = ProjectSystemUtil.getProjectSystem(project).getClassJarProvider().getModuleExternalLibraries(module2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"module!!.project.getProj\u2026ExternalLibraries(module)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (it.toPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List classPath = (List)destination$iv$iv;
        this.logger.log$intellij_android_core("Classpath = " + classPath);
        List<ClassFileResourceProvider> list3 = classPath.stream().map(new Function(this){
            final /* synthetic */ LiveEditDesugar this$0;
            {
                this.this$0 = $receiver;
            }

            public final ClassFileResourceProvider apply(Path it) {
                JarResourceCacheManager jarResourceCacheManager = LiveEditDesugar.access$getJarResourceCacheManager$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return jarResourceCacheManager.getResourceCache$intellij_android_core(it);
            }
        }).toList();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"private fun getClassPath\u2026he(it)\n    }.toList()\n  }");
        return list3;
    }

    private final Map<String, byte[]> desugarClasses(List<LiveEditCompiledClass> classes2, int version2) {
        Map modulesSet = new LinkedHashMap();
        Iterable $this$forEach$iv = classes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String moduleName2;
            LiveEditCompiledClass it = (LiveEditCompiledClass)element$iv;
            boolean bl = false;
            if (it.getModule() == null) {
                LiveEditUpdateException.Companion.desugarFailure("Cannot process class '" + it.getName() + "' without module");
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)it.getModule().getName(), (String)"it.module.name");
            if (!modulesSet.containsKey(moduleName2)) {
                modulesSet.put(moduleName2, new ArrayList());
            }
            Object v = modulesSet.get(moduleName2);
            Intrinsics.checkNotNull(v);
            ((List)v).add(it);
        }
        HashMap<String, byte[]> allDesugaredClasses = new HashMap<String, byte[]>();
        Map $this$forEach$iv2 = modulesSet;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            String moduleName3 = (String)it.getKey();
            List compiledClasses = (List)it.getValue();
            this.logger.log$intellij_android_core("Batch for module: " + moduleName3);
            Module module2 = ((LiveEditCompiledClass)((List)it.getValue()).get(0)).getModule();
            if (module2 == null) {
                LiveEditUpdateException.Companion.desugarFailure("Unable to desugar, no Module associated with " + moduleName3);
            }
            Module module3 = module2;
            Intrinsics.checkNotNull((Object)module3);
            allDesugaredClasses.putAll(this.desugarClassesForModule(compiledClasses, module3, version2));
        }
        return allDesugaredClasses;
    }

    private final Map<String, byte[]> desugarClassesForModule(List<LiveEditCompiledClass> classes2, Module module2, int minApiLevel) {
        String desugarConfig;
        ClassFileResourceProvider it;
        R8MemoryProgramResourceProvider memClassFileProvider = new R8MemoryProgramResourceProvider(classes2, this.logger);
        R8MemoryClassFileConsumer memClassFileConsumer = new R8MemoryClassFileConsumer(this.logger);
        this.logger.log$intellij_android_core("minAPILevel =" + minApiLevel);
        R8DiagnosticHandler diagnosticHandler = new R8DiagnosticHandler(this.logger);
        D8Command.Builder command = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder((DiagnosticsHandler)diagnosticHandler).addProgramResourceProvider((ProgramResourceProvider)memClassFileProvider)).setMinApiLevel(minApiLevel)).setProgramConsumer((ProgramConsumer)memClassFileConsumer);
        Iterable $this$forEach$iv = this.getAndroidJar(module2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ClassFileResourceProvider)element$iv;
            boolean bl = false;
            command.addLibraryResourceProvider(it);
        }
        $this$forEach$iv = this.getClassPathResourceProvider(module2);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ClassFileResourceProvider)element$iv;
            boolean bl = false;
            command.addClasspathResourceProvider(it);
        }
        AndroidModuleSystem moduleSys = ProjectSystemUtil.getModuleSystem(module2);
        if (!moduleSys.getDesugarLibraryConfigFilesKnown()) {
            LiveEditUpdateException.Companion.desugarFailure(String.valueOf(moduleSys.getDesugarLibraryConfigFilesNotKnownUserMessage()));
        }
        if ((desugarConfig = this.getDesugarConfig(module2)) != null) {
            command.addDesugaredLibraryConfiguration(desugarConfig);
        }
        D8.run((D8Command)((D8Command)command.build()));
        return memClassFileConsumer.getClasses();
    }

    @Override
    public void close() {
        this.jarResourceCacheManager.close();
    }

    public static final /* synthetic */ JarResourceCacheManager access$getJarResourceCacheManager$p(LiveEditDesugar $this) {
        return $this.jarResourceCacheManager;
    }
}

