/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.run.deployment.liveedit.SourceInlineCandidate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nj\u0002`\fH\u0002\u001a4\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nj\u0002`\f*\"\u0010\u0010\"\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b`\u00112\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u00a8\u0006\u0012"}, d2={"analyzeElementWithOneLevelInline", "", "element", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "requestedClasses", "Ljava/util/LinkedHashSet;", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidate;", "cache", "Ljava/util/LinkedHashMap;", "", "Lcom/android/tools/idea/run/deployment/liveedit/SourceInlineCandidateCache;", "analyzeSingleDepthInlinedFunctions", "", "file", "SourceInlineCandidateCache", "Lkotlin/collections/LinkedHashMap;", "intellij.android.core"})
public final class SingleDepthInlineAnalysisUtilsKt {
    @NotNull
    public static final Set<SourceInlineCandidate> analyzeSingleDepthInlinedFunctions(@NotNull KtFile file2, @NotNull BindingContext bindingContext, @NotNull LinkedHashMap<String, SourceInlineCandidate> cache2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter(cache2, (String)"cache");
        LinkedHashSet<SourceInlineCandidate> referencedClasses = new LinkedHashSet<SourceInlineCandidate>();
        SingleDepthInlineAnalysisUtilsKt.analyzeElementWithOneLevelInline(file2, bindingContext, referencedClasses, cache2);
        return referencedClasses;
    }

    private static final void analyzeElementWithOneLevelInline(KtFile element2, BindingContext bindingContext, LinkedHashSet<SourceInlineCandidate> requestedClasses, LinkedHashMap<String, SourceInlineCandidate> cache2) {
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Project project2 = project;
        HashSet<KtDeclarationWithBody> declarationsWithBody = new HashSet<KtDeclarationWithBody>();
        element2.accept((PsiElementVisitor)new KtTreeVisitorVoid(bindingContext, project2, declarationsWithBody){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashSet<KtDeclarationWithBody> $declarationsWithBody;
            {
                this.$bindingContext = $bindingContext;
                this.$project = $project;
                this.$declarationsWithBody = $declarationsWithBody;
            }

            public void visitExpression(@NotNull KtExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                Call call = (Call)this.$bindingContext.get((ReadOnlySlice)BindingContext.CALL, (Object)expression2);
                if (call == null) {
                    return;
                }
                Call call2 = call;
                ResolvedCall resolvedCall = (ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call2);
                this.checkResolveCall(resolvedCall);
            }

            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall = (ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
                    this.checkResolveCall(resolvedCall);
                }
            }

            public void visitForExpression(@NotNull KtForExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)expression2.getLoopRange()));
                this.checkResolveCall((ResolvedCall)this.$bindingContext.get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)expression2.getLoopRange()));
            }

            private final void checkResolveCall(ResolvedCall<?> resolvedCall) {
                if (resolvedCall == null) {
                    return;
                }
                CallableDescriptor descriptor2 = resolvedCall.getResultingDescriptor();
                if (descriptor2 instanceof DeserializedSimpleFunctionDescriptor) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)descriptor2, (String)"descriptor");
                this.isAdditionalResolveNeededForDescriptor(descriptor2);
                if (descriptor2 instanceof PropertyDescriptor) {
                    for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor2).getAccessors()) {
                        Intrinsics.checkNotNullExpressionValue((Object)accessor, (String)"accessor");
                        this.isAdditionalResolveNeededForDescriptor((CallableDescriptor)accessor);
                    }
                }
            }

            private final void isAdditionalResolveNeededForDescriptor(CallableDescriptor descriptor2) {
                if (!InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)descriptor2))) {
                    return;
                }
                PsiElement declaration = DescriptorToSourceUtilsIde.INSTANCE.getAnyDeclaration(this.$project, (DeclarationDescriptor)descriptor2);
                if (declaration != null && declaration instanceof KtDeclarationWithBody) {
                    this.$declarationsWithBody.add((KtDeclarationWithBody)declaration);
                    return;
                }
            }
        });
        for (KtDeclarationWithBody declaration : declarationsWithBody) {
            KtFile file2;
            String name2;
            declaration.getClass();
            Intrinsics.checkNotNullExpressionValue((Object)declaration, (String)"declaration");
            KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)declaration));
            if (containingClass == null) {
                KtFile ktFile2 = declaration.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"declaration.containingKtFile");
                String string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)ktFile2).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"declaration.containingKt\u2026leFacadeFqName.toString()");
                name2 = StringsKt.replace$default((String)string, (String)".", (String)"/", (boolean)false, (int)4, null);
                Intrinsics.checkNotNullExpressionValue((Object)declaration.getContainingKtFile(), (String)"declaration.containingKtFile");
                if (Intrinsics.areEqual((Object)element2, (Object)file2)) continue;
                requestedClasses.add(cache2.computeIfAbsent(name2, new Function(file2){
                    final /* synthetic */ KtFile $file;
                    {
                        this.$file = $file;
                    }

                    @NotNull
                    public final SourceInlineCandidate apply(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new SourceInlineCandidate(this.$file, it);
                    }
                }));
                continue;
            }
            name2 = StringsKt.replace$default((String)String.valueOf(FqNameUtilKt.getKotlinFqName((PsiElement)((PsiElement)containingClass))), (String)".", (String)"/", (boolean)false, (int)4, null);
            Intrinsics.checkNotNullExpressionValue((Object)declaration.getContainingKtFile(), (String)"declaration.containingKtFile");
            if (Intrinsics.areEqual((Object)element2, (Object)file2)) continue;
            requestedClasses.add(cache2.computeIfAbsent(name2, new Function(file2){
                final /* synthetic */ KtFile $file;
                {
                    this.$file = $file;
                }

                @NotNull
                public final SourceInlineCandidate apply(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return new SourceInlineCandidate(this.$file, it);
                }
            }));
        }
    }
}

