/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.run.deployment.liveedit.EditEvent;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.UnsupportedPsiEvent;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\b\u0010\f\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\b\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\bH\u0000\u001a\u0006\u0010\u0012\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"kotlinPluginId", "", "PrebuildChecks", "", "project", "Lcom/intellij/openapi/project/Project;", "changes", "", "Lcom/android/tools/idea/run/deployment/liveedit/EditEvent;", "ReadActionPrebuildChecks", "file", "Lcom/intellij/psi/PsiFile;", "checkIwiAvailable", "checkJetpackCompose", "checkKotlinPluginBundled", "checkSupportedFiles", "checkUnsupportedPsiEvents", "change", "isKotlinPluginBundled", "", "intellij.android.core"})
public final class PrebuildChecksKt {
    @NotNull
    private static final String kotlinPluginId = "org.jetbrains.kotlin";

    public static final void PrebuildChecks(@NotNull Project project, @NotNull List<EditEvent> changes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        PrebuildChecksKt.checkIwiAvailable();
        for (EditEvent change : changes) {
            PrebuildChecksKt.checkSupportedFiles(change.getFile());
            PrebuildChecksKt.checkUnsupportedPsiEvents(change);
        }
        PrebuildChecksKt.checkJetpackCompose(project);
        PrebuildChecksKt.checkKotlinPluginBundled();
    }

    public static final void checkIwiAvailable() {
        if (StudioFlags.OPTIMISTIC_INSTALL_SUPPORT_LEVEL.get() == StudioFlags.OptimisticInstallSupportLevel.DISABLED) {
            throw LiveEditUpdateException.Companion.compilationError("Cannot perform Live Edit without optimistic install support", null, null);
        }
    }

    public static final void checkSupportedFiles(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.virtualFile.path");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"buildSrc", (boolean)false, (int)2, null)) {
            String string2 = file2.getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.virtualFile.path");
            throw LiveEditUpdateException.Companion.unsupportedBuildSrcChange(string2);
        }
    }

    public static final void checkJetpackCompose(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List pluginExtensions = IrGenerationExtension.Companion.getInstances(project);
        boolean found = false;
        for (IrGenerationExtension extension : pluginExtensions) {
            if (!Intrinsics.areEqual((Object)extension.getClass().getName(), (Object)"com.android.tools.compose.ComposePluginIrGenerationExtension")) continue;
            found = true;
            break;
        }
        if (!found) {
            throw LiveEditUpdateException.Companion.compilationError("Cannot find Jetpack Compose plugin in Android Studio. Is it enabled?", null, null);
        }
    }

    public static final void checkKotlinPluginBundled() {
        if (!PrebuildChecksKt.isKotlinPluginBundled()) {
            throw LiveEditUpdateException.Companion.compilationError("Live Edit does not support running with this Kotlin Plugin version and will only work with the bundled Kotlin Plugin.", null, null);
        }
    }

    public static final void checkUnsupportedPsiEvents(@NotNull EditEvent change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (change.getUnsupportedPsiEvents().contains((Object)UnsupportedPsiEvent.CONSTRUCTORS)) {
            throw LiveEditUpdateException.Companion.unsupportedUnrecoverableSourceModification("Constructor changes", change.getFile());
        }
        if (change.getUnsupportedPsiEvents().contains((Object)UnsupportedPsiEvent.IMPORT_DIRECTIVES)) {
            throw LiveEditUpdateException.Companion.unsupportedRecoverableSourceModification("Import statement has been edited, and Live Edit is temporarily paused. Live Edit will continue on the next supported edit.", change.getFile());
        }
        if (change.getUnsupportedPsiEvents().contains((Object)UnsupportedPsiEvent.FIELD_CHANGES)) {
            throw LiveEditUpdateException.Companion.unsupportedUnrecoverableSourceModification("Field changes", change.getFile());
        }
        if (change.getUnsupportedPsiEvents().contains((Object)UnsupportedPsiEvent.NON_KOTLIN)) {
            throw LiveEditUpdateException.Companion.nonKotlin(change.getFile());
        }
        if (!change.getUnsupportedPsiEvents().isEmpty()) {
            throw LiveEditUpdateException.Companion.internalError$default(LiveEditUpdateException.Companion, "Unrecognized UnsupportedPsiEvents: " + CollectionsKt.joinToString$default((Iterable)change.getUnsupportedPsiEvents(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, 2, null);
        }
    }

    public static final boolean isKotlinPluginBundled() {
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getInstance().findEnabledPlugin(PluginId.getId((String)kotlinPluginId));
        return ideaPluginDescriptor != null ? ideaPluginDescriptor.isBundled() : false;
    }

    public static final void ReadActionPrebuildChecks(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (ProjectRootsUtilKt.getModule((PsiElement)((PsiElement)file2)) != null) {
            boolean bl;
            boolean bl2;
            Module module2 = ProjectRootsUtilKt.getModule((PsiElement)((PsiElement)file2));
            Intrinsics.checkNotNull((Object)module2);
            TestArtifactSearchScopes testArtifactSearchScopes = TestArtifactSearchScopes.Companion.getInstance(module2);
            if (testArtifactSearchScopes != null) {
                VirtualFile virtualFile = file2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.virtualFile");
                bl2 = testArtifactSearchScopes.isUnitTestSource(virtualFile);
            } else {
                bl2 = false;
            }
            if (bl2) {
                String string = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                throw LiveEditUpdateException.Companion.unsupportedTestSrcChange(string);
            }
            Module module3 = ProjectRootsUtilKt.getModule((PsiElement)((PsiElement)file2));
            Intrinsics.checkNotNull((Object)module3);
            TestArtifactSearchScopes testArtifactSearchScopes2 = TestArtifactSearchScopes.Companion.getInstance(module3);
            if (testArtifactSearchScopes2 != null) {
                VirtualFile virtualFile = file2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.virtualFile");
                bl = testArtifactSearchScopes2.isAndroidTestSource(virtualFile);
            } else {
                bl = false;
            }
            if (bl) {
                String string = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                throw LiveEditUpdateException.Companion.unsupportedTestSrcChange(string);
            }
        }
    }
}

