/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.annotations.Trace;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.deploy.proto.Deploy;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.MetricsRecorder;
import com.android.tools.deployer.tasks.LiveUpdateDeployer;
import com.android.tools.idea.editors.literals.LiveEditService;
import com.android.tools.idea.editors.liveedit.LiveEditAdvancedConfiguration;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.deployment.liveedit.DeviceEventWatcher;
import com.android.tools.idea.run.deployment.liveedit.EditEvent;
import com.android.tools.idea.run.deployment.liveedit.ErrorReporterKt;
import com.android.tools.idea.run.deployment.liveedit.LiveEditAdbEventsListener;
import com.android.tools.idea.run.deployment.liveedit.LiveEditApp;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompiler;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompilerInput;
import com.android.tools.idea.run.deployment.liveedit.LiveEditDeviceInfo;
import com.android.tools.idea.run.deployment.liveedit.LiveEditDevices;
import com.android.tools.idea.run.deployment.liveedit.LiveEditStatus;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.PrebuildChecksKt;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarResponse;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.util.StudioPathManager;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LiveEditEvent;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

public class LiveEditProjectMonitor
implements Disposable {
    private static final LogWrapper LOGGER = new LogWrapper(Logger.getInstance(LiveEditProjectMonitor.class));
    @NotNull
    private final Project project;
    private String applicationId;
    private final ScheduledExecutorService methodChangesExecutor = Executors.newSingleThreadScheduledExecutor();
    private final LiveEditDevices liveEditDevices = new LiveEditDevices();
    private final DeviceEventWatcher deviceWatcher = new DeviceEventWatcher();
    private final ArrayList<EditEvent> bufferedEvents = new ArrayList();
    private final Set<String> filesWithCompilationErrors = new HashSet<String>();
    private AtomicReference<Long> gradleTimeSync = new AtomicReference<Long>(Integer.toUnsignedLong(0));
    private final LiveEditCompiler compiler;
    private final double LE_LOG_FRACTION = 0.1;
    private static final Random randomForLogging = new Random();
    private boolean hasLoggedSinceReset = false;
    private final LiveEditAdbEventsListener adbEventsListener;
    private final ConcurrentLinkedQueue<EditEvent> changedMethodQueue = new ConcurrentLinkedQueue();

    public LiveEditProjectMonitor(@NotNull LiveEditService liveEditService, @NotNull Project project) {
        this.project = project;
        this.compiler = new LiveEditCompiler(project);
        this.adbEventsListener = liveEditService.getAdbEventsListener();
        this.gradleTimeSync.set(GradleSyncState.getInstance(project).getLastSyncFinishedTimeStamp());
        Disposer.register((Disposable)liveEditService, (Disposable)this);
        this.deviceWatcher.addListener(this.liveEditDevices::handleDeviceLifecycleEvents);
        this.adbEventsListener.addListener(this.deviceWatcher);
        this.liveEditDevices.addListener(this::handleDeviceStatusChange);
    }

    public void resetState() {
        this.bufferedEvents.clear();
        this.filesWithCompilationErrors.clear();
        this.compiler.resetState();
        this.hasLoggedSinceReset = false;
    }

    @VisibleForTesting
    int numFilesWithCompilationErrors() {
        return this.filesWithCompilationErrors.size();
    }

    @NotNull
    public Set<IDevice> devices() {
        return this.liveEditDevices.devices();
    }

    @NotNull
    public LiveEditStatus status(@NotNull IDevice device2) {
        LiveEditDeviceInfo info2 = this.liveEditDevices.getInfo(device2);
        return info2 == null ? LiveEditStatus.Disabled.INSTANCE : info2.getStatus();
    }

    public void onPsiChanged(EditEvent event2) {
        if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit()) {
            return;
        }
        if (StringUtil.isEmpty((String)this.applicationId)) {
            return;
        }
        if (this.liveEditDevices.isUnrecoverable() || this.liveEditDevices.isDisabled()) {
            return;
        }
        if (GradleSyncState.getInstance(this.project).isSyncNeeded() != ThreeState.NO || this.gradleTimeSync.get().compareTo(GradleSyncState.getInstance(this.project).getLastSyncFinishedTimeStamp()) != 0) {
            this.updateEditStatus(LiveEditStatus.SyncNeeded.INSTANCE);
            return;
        }
        this.changedMethodQueue.add(event2);
        this.methodChangesExecutor.schedule(this::processQueuedChanges, (long)LiveEditAdvancedConfiguration.getInstance().getRefreshRateMs(), TimeUnit.MILLISECONDS);
    }

    private void processQueuedChanges() {
        if (this.changedMethodQueue.isEmpty()) {
            return;
        }
        ArrayList<EditEvent> copy = new ArrayList<EditEvent>();
        this.changedMethodQueue.removeIf(e -> {
            copy.add((EditEvent)e);
            return true;
        });
        this.updateEditableStatus(LiveEditStatus.InProgress.INSTANCE);
        if (!this.handleChangedMethods(this.project, copy)) {
            this.changedMethodQueue.addAll(copy);
            this.methodChangesExecutor.schedule(this::processQueuedChanges, (long)LiveEditAdvancedConfiguration.getInstance().getRefreshRateMs(), TimeUnit.MILLISECONDS);
        }
    }

    public void dispose() {
        this.adbEventsListener.removeListener(this.deviceWatcher);
        this.liveEditDevices.clear();
        this.deviceWatcher.clearListeners();
        this.methodChangesExecutor.shutdownNow();
    }

    public LiveEditCompiler getCompiler() {
        return this.compiler;
    }

    public boolean notifyExecution(@NotNull Collection<IDevice> devices2) {
        HashSet<IDevice> newDevices = new HashSet<IDevice>(devices2);
        newDevices.removeIf(d -> !LiveEditProjectMonitor.supportLiveEdits(d));
        Ref multiDeploy = new Ref((Object)false);
        this.liveEditDevices.update((Function2<? super IDevice, ? super LiveEditStatus, ? extends LiveEditStatus>)((Function2)(oldDevice, status2) -> {
            if (newDevices.contains(oldDevice)) {
                return status2 == LiveEditStatus.NoMultiDeploy.INSTANCE ? LiveEditStatus.Disabled.INSTANCE : status2;
            }
            if (status2 == LiveEditStatus.Disabled.INSTANCE) {
                return status2;
            }
            multiDeploy.set((Object)true);
            return LiveEditStatus.NoMultiDeploy.INSTANCE;
        }));
        return (Boolean)multiDeploy.get();
    }

    public boolean notifyAppRefresh(@NotNull IDevice device2) {
        if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit() || !LiveEditProjectMonitor.supportLiveEdits(device2)) {
            return false;
        }
        this.liveEditDevices.update(device2, LiveEditStatus.UpToDate.INSTANCE);
        return true;
    }

    public boolean notifyAppDeploy(String applicationId2, IDevice device2, @NotNull LiveEditApp app, @NotNull Supplier<Boolean> isLiveEditable) throws ExecutionException, InterruptedException {
        if (!isLiveEditable.get().booleanValue()) {
            LOGGER.info("Can not live edit the app due to either non-debuggability or does not use Compose", new Object[0]);
            this.liveEditDevices.clear(device2);
            return false;
        }
        if (!LiveEditApplicationConfiguration.getInstance().isLiveEdit()) {
            if (LiveEditProjectMonitor.supportLiveEdits(device2) && LiveEditService.usesCompose(this.project)) {
                LiveEditService.getInstance(this.project).notifyLiveEditAvailability(device2);
            }
            LOGGER.info("Live Edit on device disabled via settings.", new Object[0]);
            return false;
        }
        if (!LiveEditProjectMonitor.supportLiveEdits(device2)) {
            LOGGER.info("Live edit not support for device %s targeting app %s", new Object[]{this.project.getName(), applicationId2});
            this.liveEditDevices.addDevice(device2, LiveEditStatus.UnsupportedVersion.INSTANCE, app);
            return false;
        }
        LOGGER.info("Creating monitor for project %s targeting app %s", new Object[]{this.project.getName(), applicationId2});
        this.liveEditDevices.addDevice(device2, LiveEditStatus.Loading.INSTANCE, app);
        this.methodChangesExecutor.schedule(() -> {
            this.applicationId = applicationId2;
            this.gradleTimeSync.set(GradleSyncState.getInstance(this.project).getLastSyncFinishedTimeStamp());
            this.resetState();
            this.deviceWatcher.setApplicationId(applicationId2);
        }, 0L, TimeUnit.NANOSECONDS).get();
        return true;
    }

    @VisibleForTesting
    @NotNull
    public LiveEditDevices getLiveEditDevices() {
        return this.liveEditDevices;
    }

    @Trace
    public void onManualLETrigger() {
        this.methodChangesExecutor.schedule(this::doOnManualLETrigger, 0L, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    void doOnManualLETrigger() {
        if (this.bufferedEvents.isEmpty()) {
            return;
        }
        this.updateEditableStatus(LiveEditStatus.InProgress.INSTANCE);
        while (!this.processChanges(this.project, this.bufferedEvents, LiveEditEvent.Mode.MANUAL)) {
            LOGGER.info("ProcessChanges was interrupted", new Object[0]);
        }
        this.bufferedEvents.clear();
    }

    @Trace
    boolean handleChangedMethods(Project project, List<EditEvent> changes) {
        LOGGER.info("Change detected for project %s targeting app %s", new Object[]{project.getName(), this.applicationId});
        if (LiveEditService.Companion.isLeTriggerManual()) {
            this.updateEditableStatus(LiveEditStatus.OutOfDate.INSTANCE);
            if (this.bufferedEvents.size() < 2000) {
                this.bufferedEvents.addAll(changes);
            } else {
                this.updateEditableStatus(LiveEditStatus.createErrorStatus("Too many buffered LE keystrokes. Redeploy app."));
            }
            return true;
        }
        return this.processChanges(project, changes, LiveEditEvent.Mode.AUTO);
    }

    @Trace
    @VisibleForTesting
    boolean processChanges(Project project, List<EditEvent> changes, LiveEditEvent.Mode mode) {
        Optional<LiveEditDesugarResponse> compiled;
        LiveEditEvent.Builder event2 = LiveEditEvent.newBuilder().setMode(mode);
        long start2 = System.nanoTime();
        try {
            PrebuildChecksKt.PrebuildChecks(project, changes);
            List<LiveEditCompilerInput> inputs = changes.stream().map(change -> new LiveEditCompilerInput(change.getFile(), change.getOrigin(), change.getParentGroup())).collect(Collectors.toList());
            Set<Integer> minApis = this.getDevicesApiLevels();
            compiled = this.compiler.compile(inputs, !LiveEditService.isLeTriggerManual(), minApis);
            if (compiled.isEmpty()) {
                return false;
            }
            for (EditEvent change2 : changes) {
                this.filesWithCompilationErrors.remove(change2.getFile().getName());
            }
        }
        catch (LiveEditUpdateException e) {
            boolean recoverable = e.getError().getRecoverable();
            this.updateEditableStatus(recoverable ? LiveEditStatus.createPausedStatus(ErrorReporterKt.errorMessage(e)) : LiveEditStatus.createRerunnableErrorStatus(ErrorReporterKt.errorMessage(e)));
            if (recoverable) {
                for (EditEvent change3 : changes) {
                    this.filesWithCompilationErrors.add(change3.getFile().getName());
                }
            } else {
                event2.setStatus(e.getError().getMetric());
            }
            this.logLiveEditEvent(event2);
            return true;
        }
        if (mode == LiveEditEvent.Mode.AUTO && !this.filesWithCompilationErrors.isEmpty()) {
            Optional errorFilename = this.filesWithCompilationErrors.stream().findFirst();
            String errorMsg = ErrorReporterKt.leErrorMessage(LiveEditUpdateException.Error.COMPILATION_ERROR, (String)errorFilename.get());
            this.updateEditStatus(LiveEditStatus.createPausedStatus(errorMsg));
            this.logLiveEditEvent(event2);
            return true;
        }
        LiveEditDesugarResponse desugaredResponse = compiled.get();
        event2.setHasNonCompose(desugaredResponse.resetState());
        long compileFinish = System.nanoTime();
        event2.setCompileDurationMs(TimeUnit.NANOSECONDS.toMillis(compileFinish - start2));
        LOGGER.info("LiveEdit compile completed in %dms", new Object[]{event2.getCompileDurationMs()});
        List errors2 = this.editableDeviceIterator().map(device2 -> this.pushUpdatesToDevice((String)this.applicationId, (IDevice)device2, (LiveEditDesugarResponse)desugaredResponse).errors).flatMap(Collection::stream).toList();
        if (!errors2.isEmpty()) {
            event2.setStatus(LiveEditProjectMonitor.errorToStatus((LiveUpdateDeployer.UpdateLiveEditError)errors2.get(0)));
        } else {
            event2.setStatus(LiveEditEvent.Status.SUCCESS);
        }
        long pushFinish = System.nanoTime();
        event2.setPushDurationMs(TimeUnit.NANOSECONDS.toMillis(pushFinish - compileFinish));
        LOGGER.info("LiveEdit push completed in %dms", new Object[]{event2.getPushDurationMs()});
        this.logLiveEditEvent(event2);
        return true;
    }

    @NotNull
    private Set<Integer> getDevicesApiLevels() {
        return this.editableDeviceIterator().map(device2 -> this.liveEditDevices.getInfo((IDevice)device2).getApp().getMinAPI()).collect(Collectors.toSet());
    }

    public void requestRerun() {
        for (IDevice device2 : AndroidDebugBridge.getBridge().getDevices()) {
            this.liveEditDevices.addDevice(device2, LiveEditStatus.createRerunnableErrorStatus("Re-run application to start Live Edit updates."));
        }
    }

    private void scheduleErrorPolling(LiveUpdateDeployer deployer, Installer installer, AdbClient adb, String packageName2) {
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        ScheduledFuture<?> statusPolling = scheduler.scheduleWithFixedDelay(() -> {
            List errors2 = deployer.retrieveComposeStatus(installer, adb, packageName2);
            if (!errors2.isEmpty()) {
                Deploy.ComposeException error = (Deploy.ComposeException)errors2.get(0);
                this.updateEditableStatus(LiveEditStatus.createRecomposeErrorStatus(error.getExceptionClassName(), error.getMessage(), error.getRecoverable()));
            }
        }, 2L, 2L, TimeUnit.SECONDS);
        scheduler.schedule(() -> statusPolling.cancel(true), 10L, TimeUnit.SECONDS);
    }

    public void clearDevices() {
        this.liveEditDevices.clear();
    }

    private static LiveEditEvent.Status errorToStatus(LiveUpdateDeployer.UpdateLiveEditError error) {
        switch (error.getType()) {
            case ADDED_METHOD: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_METHOD;
            }
            case REMOVED_METHOD: {
                return LiveEditEvent.Status.UNSUPPORTED_REMOVED_METHOD;
            }
            case ADDED_CLASS: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_CLASS;
            }
            case ADDED_FIELD: 
            case MODIFIED_FIELD: {
                return LiveEditEvent.Status.UNSUPPORTED_ADDED_FIELD;
            }
            case REMOVED_FIELD: {
                return LiveEditEvent.Status.UNSUPPORTED_REMOVED_FIELD;
            }
            case MODIFIED_SUPER: 
            case ADDED_INTERFACE: 
            case REMOVED_INTERFACE: {
                return LiveEditEvent.Status.UNSUPPORTED_MODIFY_INHERITANCE;
            }
            case UNSUPPORTED_COMPOSE_VERSION: {
                return LiveEditEvent.Status.UNKNOWN;
            }
        }
        return LiveEditEvent.Status.UNKNOWN;
    }

    private void logLiveEditEvent(LiveEditEvent.Builder event2) {
        if (!this.hasLoggedSinceReset || randomForLogging.nextDouble() < 0.1) {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.LIVE_EDIT_EVENT).setLiveEditEvent(event2), this.project));
            this.hasLoggedSinceReset = true;
        }
    }

    private void updateEditStatus(@NotNull IDevice device2, @NotNull LiveEditStatus status2) {
        this.liveEditDevices.update(device2, status2);
    }

    private void updateEditStatus(@NotNull LiveEditStatus status2) {
        this.liveEditDevices.update(status2);
    }

    private void updateEditableStatus(@NotNull LiveEditStatus newStatus) {
        this.liveEditDevices.update((Function2<? super IDevice, ? super LiveEditStatus, ? extends LiveEditStatus>)((Function2)(device2, prevStatus) -> prevStatus.unrecoverable() || prevStatus == LiveEditStatus.Disabled.INSTANCE || prevStatus == LiveEditStatus.NoMultiDeploy.INSTANCE ? prevStatus : newStatus));
    }

    private void handleDeviceStatusChange(Map<IDevice, LiveEditStatus> map2) {
        ActivityTracker.getInstance().inc();
    }

    private Stream<IDevice> editableDeviceIterator() {
        return this.liveEditDevices.devices().stream().filter(IDevice::isOnline).filter(device2 -> this.liveEditDevices.getInfo((IDevice)device2).getStatus() != LiveEditStatus.Disabled.INSTANCE && this.liveEditDevices.getInfo((IDevice)device2).getStatus() != LiveEditStatus.NoMultiDeploy.INSTANCE);
    }

    private static Installer newInstaller(IDevice device2) {
        MetricsRecorder metrics = new MetricsRecorder();
        AdbClient adb = new AdbClient(device2, (ILogger)LOGGER);
        return new AdbInstaller(LiveEditProjectMonitor.getLocalInstaller(), adb, (Collection)metrics.getDeployMetrics(), (ILogger)LOGGER, AdbInstaller.Mode.DAEMON);
    }

    private LiveUpdateDeployer.UpdateLiveEditResult pushUpdatesToDevice(String applicationId2, IDevice device2, LiveEditDesugarResponse update2) {
        LiveUpdateDeployer deployer = new LiveUpdateDeployer((ILogger)LOGGER);
        Installer installer = LiveEditProjectMonitor.newInstaller(device2);
        AdbClient adb = new AdbClient(device2, (ILogger)LOGGER);
        boolean useDebugMode = LiveEditAdvancedConfiguration.getInstance().getUseDebugMode();
        boolean resetState = update2.resetState();
        boolean usePartialRecompose = LiveEditAdvancedConfiguration.getInstance().getUsePartialRecompose() && !resetState;
        int apiLevel = this.liveEditDevices.getInfo(device2).getApp().getMinAPI();
        LiveUpdateDeployer.UpdateLiveEditsParam param = new LiveUpdateDeployer.UpdateLiveEditsParam(update2.classes(apiLevel), update2.supportClasses(apiLevel), update2.groupIds(), usePartialRecompose, useDebugMode);
        LiveUpdateDeployer.UpdateLiveEditResult result2 = deployer.updateLiveEdit(installer, adb, applicationId2, param);
        if (this.filesWithCompilationErrors.isEmpty()) {
            this.updateEditStatus(device2, LiveEditStatus.UpToDate.INSTANCE);
        } else {
            Optional errorFilename = ((Stream)this.filesWithCompilationErrors.stream().sequential()).findFirst();
            String errorMsg = ErrorReporterKt.leErrorMessage(LiveEditUpdateException.Error.COMPILATION_ERROR, (String)errorFilename.get());
            this.updateEditStatus(device2, LiveEditStatus.createPausedStatus(errorMsg));
        }
        this.scheduleErrorPolling(deployer, installer, adb, applicationId2);
        if (!result2.errors.isEmpty()) {
            LiveUpdateDeployer.UpdateLiveEditError firstProblem = (LiveUpdateDeployer.UpdateLiveEditError)result2.errors.get(0);
            if (firstProblem.getType() == Deploy.UnsupportedChange.Type.UNSUPPORTED_COMPOSE_VERSION) {
                this.updateEditStatus(device2, LiveEditStatus.createComposeVersionError(firstProblem.getMessage()));
            } else {
                this.updateEditStatus(device2, LiveEditStatus.createRerunnableErrorStatus(firstProblem.getMessage()));
            }
        }
        return result2;
    }

    public static boolean supportLiveEdits(IDevice device2) {
        return device2.getVersion().isGreaterOrEqualThan(30);
    }

    private static String getLocalInstaller() {
        Path path2 = StudioPathManager.isRunningFromSources() ? StudioPathManager.resolvePathFromSourcesRoot((String)"bazel-bin/tools/base/deploy/installer/android-installer") : Paths.get(PathManager.getHomePath(), "plugins/android/resources/installer");
        return path2.toString();
    }
}

