/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.editors.liveedit.LiveEditAdvancedConfiguration;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompiledClass;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\fJ-\u0010\r\u001a\u00020\b2\u001e\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000e0\u000eH\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0015\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0016J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "", "tag", "", "(Ljava/lang/String;)V", "getTag", "()Ljava/lang/String;", "dumpCompilerOutputs", "", "outputs", "", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompiledClass;", "dumpCompilerOutputs$intellij_android_core", "dumpDesugarOutputs", "", "", "", "dumpDesugarOutputs$intellij_android_core", "enabled", "", "log", "message", "log$intellij_android_core", "writeDebugToTmp", "name", "data", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditLogger.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditLogger\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,76:1\n211#2,2:77\n*S KotlinDebug\n*F\n+ 1 LiveEditLogger.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditLogger\n*L\n56#1:77,2\n*E\n"})
public final class LiveEditLogger {
    @NotNull
    private final String tag;

    public LiveEditLogger(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    public final void log$intellij_android_core(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        if (!this.enabled()) {
            return;
        }
        System.out.println((Object)(this.tag + ": " + message2));
    }

    private final boolean enabled() {
        try {
            return LiveEditAdvancedConfiguration.Companion.getInstance().getUseDebugMode();
        }
        catch (Exception e) {
            return false;
        }
    }

    public final void dumpCompilerOutputs$intellij_android_core(@NotNull List<LiveEditCompiledClass> outputs) {
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        if (!LiveEditAdvancedConfiguration.Companion.getInstance().getUseDebugMode()) {
            return;
        }
        for (LiveEditCompiledClass clazz : outputs) {
            CharSequence charSequence = clazz.getName();
            Regex regex = new Regex("/");
            String string = ".";
            this.writeDebugToTmp(regex.replace(charSequence, string) + ".class", clazz.getData());
        }
    }

    public final void dumpDesugarOutputs$intellij_android_core(@NotNull Map<Integer, ? extends Map<String, byte[]>> outputs) {
        Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
        if (!LiveEditAdvancedConfiguration.Companion.getInstance().getUseDebugMode()) {
            return;
        }
        for (Map.Entry<Integer, ? extends Map<String, byte[]>> versionClasses : outputs.entrySet()) {
            int apiLevel = ((Number)versionClasses.getKey()).intValue();
            Map<String, byte[]> $this$forEach$iv = versionClasses.getValue();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, byte[]>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, byte[]> element$iv;
                Map.Entry<String, byte[]> it = element$iv = iterator2.next();
                boolean bl = false;
                String className = it.getKey();
                byte[] data = it.getValue();
                CharSequence charSequence = className;
                Regex regex = new Regex("/");
                String string = ".";
                this.writeDebugToTmp(regex.replace(charSequence, string) + "." + apiLevel + ".class", data);
            }
        }
    }

    private final void writeDebugToTmp(String name2, byte[] data) {
        String string = System.getProperty("java.io.tmpdir");
        if (string == null) {
            return;
        }
        String tmpPath = string;
        String[] stringArray = new String[]{name2};
        Path path2 = Paths.get(tmpPath, stringArray);
        try {
            Files.write(path2, data, new OpenOption[0]);
            this.log$intellij_android_core("Wrote debug file at '" + path2.toAbsolutePath() + "'");
        }
        catch (IOException e) {
            this.log$intellij_android_core("Unable to write debug file '" + path2.toAbsolutePath() + "'");
        }
    }
}

