/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.LiveEditMarkerInfoConsumer;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.r8.ExtractMarker;
import com.android.tools.r8.ExtractMarkerCommand;
import com.android.tools.r8.MarkerInfoConsumer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0013\u001a\u00060\u0006j\u0002`\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0010\u0010\t\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000e\u001a\u00060\u0006j\u0002`\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/LiveEditApp;", "", "apks", "", "Ljava/nio/file/Path;", "deviceMinAPI", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/MinApiLevel;", "(Ljava/util/Set;I)V", "journal", "", "", "logger", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "minAPI", "getMinAPI", "()I", "minAPI$delegate", "Lkotlin/Lazy;", "calculateMinAPI", "", "msg", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditApp.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditApp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1851#2,2:64\n*S KotlinDebug\n*F\n+ 1 LiveEditApp.kt\ncom/android/tools/idea/run/deployment/liveedit/LiveEditApp\n*L\n37#1:64,2\n*E\n"})
public final class LiveEditApp {
    @NotNull
    private final Set<Path> apks;
    private final int deviceMinAPI;
    @NotNull
    private final Lazy minAPI$delegate;
    @NotNull
    private final LiveEditLogger logger;
    @NotNull
    private final List<String> journal;

    public LiveEditApp(@NotNull Set<? extends Path> apks2, int deviceMinAPI) {
        Intrinsics.checkNotNullParameter(apks2, (String)"apks");
        this.apks = apks2;
        this.deviceMinAPI = deviceMinAPI;
        this.minAPI$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ LiveEditApp this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return LiveEditApp.access$calculateMinAPI(this.this$0, LiveEditApp.access$getApks$p(this.this$0));
            }
        }));
        this.logger = new LiveEditLogger("LE App");
        this.journal = new ArrayList();
    }

    public final int getMinAPI() {
        Lazy lazy = this.minAPI$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final int calculateMinAPI(Set<? extends Path> apks2) {
        long start2 = System.nanoTime();
        Set minApis = new LinkedHashSet();
        Iterable $this$forEach$iv = apks2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Path apk = it;
            LiveEditMarkerInfoConsumer consumer = new LiveEditMarkerInfoConsumer();
            Path[] pathArray = new Path[]{apk};
            ExtractMarker.run((ExtractMarkerCommand)ExtractMarkerCommand.builder().addProgramFiles(pathArray).setMarkerInfoConsumer((MarkerInfoConsumer)consumer).build());
            this.journal("Apk '" + apk.getFileName() + "' contains minAPI = " + consumer.getMinApis());
            minApis.addAll((Collection)consumer.getMinApis());
        }
        if (minApis.size() > 1) {
            LiveEditUpdateException.Companion.desugarFailure("Too many minAPI. Details:\n " + CollectionsKt.joinToString$default((Iterable)this.journal, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        if (minApis.isEmpty()) {
            this.logger.log$intellij_android_core("APks " + apks2 + " did not contain R8 markers (not desugared?). Falling back to api=" + this.deviceMinAPI);
            minApis.add(this.deviceMinAPI);
        }
        long duration2 = (System.nanoTime() - start2) / (long)1000000;
        this.logger.log$intellij_android_core("Found minAPI = " + minApis + " in " + duration2 + "ms");
        return ((Number)CollectionsKt.first((Iterable)minApis)).intValue();
    }

    private final void journal(String msg) {
        this.logger.log$intellij_android_core(msg);
        this.journal.add(msg);
    }

    public static final /* synthetic */ int access$calculateMinAPI(LiveEditApp $this, Set apks2) {
        return $this.calculateMinAPI(apks2);
    }

    public static final /* synthetic */ Set access$getApks$p(LiveEditApp $this) {
        return $this.apks;
    }
}

