/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.deployment.liveedit.AllAdbEventsListener;
import com.android.tools.idea.run.deployment.liveedit.DeviceEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/DeviceEventWatcher;", "Lcom/android/tools/idea/run/deployment/liveedit/AllAdbEventsListener;", "()V", "applicationId", "", "devicesWithConnectedClients", "", "Lcom/android/ddmlib/IDevice;", "listeners", "", "Ljava/util/function/BiConsumer;", "Lcom/android/tools/idea/run/deployment/liveedit/DeviceEvent;", "Lcom/android/tools/idea/run/deployment/liveedit/DeviceEventListener;", "addListener", "", "listener", "clearListeners", "", "clientChanged", "client", "Lcom/android/ddmlib/Client;", "changeMask", "", "deviceChanged", "device", "deviceConnected", "deviceDisconnected", "notifyListeners", "event", "setApplicationId", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nDeviceEventWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceEventWatcher.kt\ncom/android/tools/idea/run/deployment/liveedit/DeviceEventWatcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n12708#2,2:91\n1851#3,2:93\n*S KotlinDebug\n*F\n+ 1 DeviceEventWatcher.kt\ncom/android/tools/idea/run/deployment/liveedit/DeviceEventWatcher\n*L\n58#1:91,2\n89#1:93,2\n*E\n"})
public final class DeviceEventWatcher
implements AllAdbEventsListener {
    @NotNull
    private String applicationId = "";
    @NotNull
    private final List<BiConsumer<IDevice, DeviceEvent>> listeners = new ArrayList();
    @NotNull
    private final Set<IDevice> devicesWithConnectedClients = new LinkedHashSet();

    public void deviceConnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.notifyListeners(device2, DeviceEvent.DEVICE_DISCONNECT);
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            if ((changeMask & 2) == 0) {
                return;
            }
            if (!this.devicesWithConnectedClients.contains(device2)) {
                return;
            }
            Client[] clientArray = device2.getClients();
            Intrinsics.checkNotNullExpressionValue((Object)clientArray, (String)"device.clients");
            Object[] $this$any$iv = clientArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Client it = (Client)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getClientData().getPackageName(), (Object)this.applicationId) && it.isValid())) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (!bl) {
            this.notifyListeners(device2, DeviceEvent.APPLICATION_DISCONNECT);
            this.devicesWithConnectedClients.remove(device2);
        }
    }

    public void clientChanged(@NotNull Client client2, int changeMask) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        if (!Intrinsics.areEqual((Object)client2.getClientData().getPackageName(), (Object)this.applicationId)) {
            return;
        }
        if ((changeMask & 1) != 0) {
            IDevice iDevice = client2.getDevice();
            Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"client.device");
            this.notifyListeners(iDevice, DeviceEvent.APPLICATION_CONNECT);
            IDevice iDevice2 = client2.getDevice();
            Intrinsics.checkNotNullExpressionValue((Object)iDevice2, (String)"client.device");
            this.devicesWithConnectedClients.add(iDevice2);
        }
        if ((changeMask & 2) != 0) {
            DeviceEvent event2 = client2.isDebuggerAttached() ? DeviceEvent.DEBUGGER_CONNECT : DeviceEvent.DEBUGGER_DISCONNECT;
            IDevice iDevice = client2.getDevice();
            Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"client.device");
            this.notifyListeners(iDevice, event2);
        }
    }

    public final void setApplicationId(@NotNull String applicationId2) {
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        this.applicationId = applicationId2;
    }

    public final boolean addListener(@NotNull BiConsumer<IDevice, DeviceEvent> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        return this.listeners.add(listener2);
    }

    public final void clearListeners() {
        this.listeners.clear();
    }

    private final void notifyListeners(IDevice device2, DeviceEvent event2) {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BiConsumer it = (BiConsumer)element$iv;
            boolean bl = false;
            it.accept(device2, event2);
        }
    }
}

