/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.Tasks;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevicesTask
implements AsyncSupplier<Collection<VirtualDevice>> {
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final Supplier<Collection<AvdInfo>> myGetAvds;
    @NotNull
    private final Function<AvdInfo, AndroidDevice> myNewLaunchableAndroidDevice;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;

    private VirtualDevicesTask(@NotNull Builder builder2) {
        assert (builder2.myExecutorService != null);
        this.myExecutorService = builder2.myExecutorService;
        assert (builder2.myGetAvds != null);
        this.myGetAvds = builder2.myGetAvds;
        assert (builder2.myNewLaunchableAndroidDevice != null);
        this.myNewLaunchableAndroidDevice = builder2.myNewLaunchableAndroidDevice;
        this.myChecker = builder2.myChecker;
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<VirtualDevice>> get() {
        return MoreExecutors.listeningDecorator((ExecutorService)this.myExecutorService).submit(this::getVirtualDevices);
    }

    @NotNull
    private Collection<VirtualDevice> getVirtualDevices() {
        return this.myGetAvds.get().stream().map(avd -> this.newDisconnectedDevice((AvdInfo)avd, this.getSnapshots((AvdInfo)avd))).collect(Collectors.toList());
    }

    @NotNull
    private Collection<Snapshot> getSnapshots(@NotNull AvdInfo device2) {
        Collection collection2;
        block9: {
            Path snapshots = device2.getDataFolderPath().resolve("snapshots");
            if (!Files.isDirectory(snapshots, new LinkOption[0])) {
                return ImmutableList.of();
            }
            Stream<Path> stream = Files.list(snapshots);
            try {
                Path defaultBoot = snapshots.getFileSystem().getPath("default_boot", new String[0]);
                collection2 = (Collection)stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(directory -> !directory.getFileName().equals(defaultBoot)).map(this::getSnapshot).filter(Objects::nonNull).sorted().collect(ImmutableList.toImmutableList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Logger.getInstance(VirtualDevicesTask.class).warn(snapshots.toString(), (Throwable)exception);
                    return ImmutableList.of();
                }
            }
            stream.close();
        }
        return collection2;
    }

    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull Path snapshotDirectory) {
        Snapshot snapshot;
        block9: {
            Path snapshotProtocolBuffer = snapshotDirectory.resolve("snapshot.pb");
            if (!Files.exists(snapshotProtocolBuffer, new LinkOption[0])) {
                return new Snapshot(snapshotDirectory);
            }
            InputStream in = Files.newInputStream(snapshotProtocolBuffer, new OpenOption[0]);
            try {
                snapshot = this.getSnapshot(SnapshotOuterClass.Snapshot.parseFrom((InputStream)in), snapshotDirectory);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Logger.getInstance(VirtualDevicesTask.class).warn(snapshotDirectory.toString(), (Throwable)exception);
                    return null;
                }
            }
            in.close();
        }
        return snapshot;
    }

    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull SnapshotOuterClass.Snapshot snapshot, @NotNull Path snapshotDirectory) {
        if (snapshot.getImagesCount() == 0) {
            return null;
        }
        String name2 = snapshot.getLogicalName();
        if (name2.isEmpty()) {
            return new Snapshot(snapshotDirectory);
        }
        return new Snapshot(snapshotDirectory, name2);
    }

    @NotNull
    private VirtualDevice newDisconnectedDevice(@NotNull AvdInfo avd, @NotNull Collection<Snapshot> snapshots) {
        AndroidDevice device2 = this.myNewLaunchableAndroidDevice.apply(avd);
        VirtualDevice.Builder builder2 = new VirtualDevice.Builder().setName(avd.getDisplayName()).setKey(new VirtualDevicePath(avd.getDataFolderPath().toString())).setAndroidDevice(device2).setNameKey(new VirtualDeviceName(avd.getName())).addAllSnapshots(snapshots).setType(Tasks.getTypeFromAndroidDevice(device2));
        if (this.myChecker == null) {
            return builder2.build();
        }
        return builder2.setLaunchCompatibility(this.myChecker.validate(device2)).build();
    }

    static final class Builder {
        @Nullable
        private ExecutorService myExecutorService;
        @Nullable
        private Supplier<Collection<AvdInfo>> myGetAvds;
        @Nullable
        private Function<AvdInfo, AndroidDevice> myNewLaunchableAndroidDevice;
        @Nullable
        private LaunchCompatibilityChecker myChecker;

        Builder() {
        }

        @NotNull
        Builder setExecutorService(@NotNull ExecutorService executorService) {
            this.myExecutorService = executorService;
            return this;
        }

        @NotNull
        Builder setGetAvds(@NotNull Supplier<Collection<AvdInfo>> getAvds) {
            this.myGetAvds = getAvds;
            return this;
        }

        @NotNull
        Builder setNewLaunchableAndroidDevice(@NotNull Function<AvdInfo, AndroidDevice> newLaunchableAndroidDevice) {
            this.myNewLaunchableAndroidDevice = newLaunchableAndroidDevice;
            return this;
        }

        @NotNull
        Builder setChecker(@Nullable LaunchCompatibilityChecker checker) {
            this.myChecker = checker;
            return this;
        }

        @NotNull
        VirtualDevicesTask build() {
            return new VirtualDevicesTask(this);
        }
    }
}

