/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.configuration.AndroidWearConfiguration;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Target;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import icons.StudioIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Updater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Presentation myPresentation;
    @NotNull
    private final String myPlace;
    @NotNull
    private final DevicesSelectedService myDevicesSelectedService;
    @NotNull
    private final List<Device> myDevices;
    @Nullable
    private final RunnerAndConfigurationSettings myConfigurationAndSettings;
    @NotNull
    private final BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet;

    private Updater(@NotNull Builder builder2) {
        assert (builder2.myProject != null);
        this.myProject = builder2.myProject;
        assert (builder2.myPresentation != null);
        this.myPresentation = builder2.myPresentation;
        this.myPlace = builder2.myPlace;
        assert (builder2.myDevicesSelectedService != null);
        this.myDevicesSelectedService = builder2.myDevicesSelectedService;
        this.myDevices = builder2.myDevices;
        this.myConfigurationAndSettings = builder2.myConfigurationAndSettings;
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet = builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet;
    }

    void update() {
        if (!AndroidUtils.hasAndroidFacets(this.myProject)) {
            this.myPresentation.setVisible(false);
            return;
        }
        this.myPresentation.setVisible(true);
        this.updateDependingOnConfiguration();
        switch (this.myPlace) {
            case "MainToolbar": 
            case "NavBarToolbar": {
                if (this.myDevicesSelectedService.isMultipleDevicesSelectedInComboBox()) {
                    this.updateInToolbarForMultipleDevices();
                    break;
                }
                this.updateInToolbarForSingleDevice();
                break;
            }
            default: {
                this.myPresentation.setIcon(null);
                this.myPresentation.setText("Select Device...");
            }
        }
    }

    private void updateDependingOnConfiguration() {
        if (this.myConfigurationAndSettings == null) {
            this.myPresentation.setEnabled(false);
            this.myPresentation.setDescription("Add a run/debug configuration");
            return;
        }
        RunConfiguration configuration = this.myConfigurationAndSettings.getConfiguration();
        if (configuration instanceof AndroidRunConfiguration || configuration instanceof AndroidTestRunConfiguration || configuration instanceof AndroidWearConfiguration) {
            this.myPresentation.setEnabled(true);
            this.myPresentation.setDescription((String)null);
            return;
        }
        if (this.configurationDeploysToLocalDevice()) {
            this.myPresentation.setEnabled(true);
            this.myPresentation.setDescription((String)null);
            return;
        }
        this.myPresentation.setEnabled(false);
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.myPresentation.setDescription("Not applicable for the \"" + configuration.getName() + "\" configuration");
        } else {
            this.myPresentation.setVisible(false);
        }
    }

    private boolean configurationDeploysToLocalDevice() {
        assert (this.myConfigurationAndSettings != null);
        RunConfiguration configuration = this.myConfigurationAndSettings.getConfiguration();
        if (!(configuration instanceof UserDataHolder)) {
            return false;
        }
        Boolean deploysToLocalDevice = (Boolean)((UserDataHolder)configuration).getUserData(DeviceAndSnapshotComboBoxAction.DEPLOYS_TO_LOCAL_DEVICE);
        return deploysToLocalDevice != null && deploysToLocalDevice != false;
    }

    private void updateInToolbarForMultipleDevices() {
        Set targets;
        Set<Target> selectedTargets = this.myDevicesSelectedService.getTargetsSelectedWithDialog(this.myDevices);
        if (selectedTargets.retainAll(targets = this.myDevices.stream().map(Device::getTargets).flatMap(Collection::stream).collect(Collectors.toSet()))) {
            this.myDevicesSelectedService.setTargetsSelectedWithDialog(selectedTargets);
        }
        if (selectedTargets.isEmpty()) {
            this.myDevicesSelectedService.setMultipleDevicesSelectedInComboBox(false);
            Target selectedTarget = this.myDevicesSelectedService.getTargetSelectedWithComboBox(this.myDevices).orElse(null);
            this.myDevicesSelectedService.setTargetSelectedWithComboBox(selectedTarget);
            this.updateInToolbarForSingleDevice();
            return;
        }
        this.myPresentation.setIcon(StudioIcons.DeviceExplorer.MULTIPLE_DEVICES);
        this.myPresentation.setText("Multiple Devices (" + selectedTargets.size() + ")");
    }

    private void updateInToolbarForSingleDevice() {
        if (this.myDevices.isEmpty()) {
            this.myPresentation.setIcon(null);
            this.myPresentation.setText("No Devices");
            return;
        }
        Target target2 = this.myDevicesSelectedService.getTargetSelectedWithComboBox(this.myDevices).orElseThrow(AssertionError::new);
        Key key = target2.getDeviceKey();
        Device device2 = this.myDevices.stream().filter(d -> d.getKey().equals(key)).findFirst().orElseThrow(AssertionError::new);
        this.myPresentation.setIcon(device2.getIcon());
        this.myPresentation.setText(this.getText(device2, target2), false);
    }

    @NotNull
    private String getText(@NotNull Device device2, @NotNull Target target2) {
        Key key = Devices.containsAnotherDeviceWithSameName(this.myDevices, device2) ? device2.getKey() : null;
        String bootOption = Devices.getBootOption(device2, target2, this.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet).orElse(null);
        return Devices.getText(device2, key, bootOption);
    }

    static final class Builder {
        @Nullable
        private Project myProject;
        @Nullable
        private Presentation myPresentation;
        @NotNull
        private String myPlace = "MainToolbar";
        @Nullable
        private DevicesSelectedService myDevicesSelectedService;
        @NotNull
        private List<Device> myDevices = Collections.emptyList();
        @Nullable
        private RunnerAndConfigurationSettings myConfigurationAndSettings;
        @NotNull
        private BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet = () -> false;

        Builder() {
        }

        @NotNull
        Builder setProject(@NotNull Project project) {
            this.myProject = project;
            return this;
        }

        @NotNull
        Builder setPresentation(@NotNull Presentation presentation) {
            this.myPresentation = presentation;
            return this;
        }

        @NotNull
        Builder setPlace(@NotNull String place) {
            this.myPlace = place;
            return this;
        }

        @NotNull
        Builder setDevicesSelectedService(@NotNull DevicesSelectedService devicesSelectedService) {
            this.myDevicesSelectedService = devicesSelectedService;
            return this;
        }

        @NotNull
        Builder setDevices(@NotNull List<Device> devices2) {
            this.myDevices = devices2;
            return this;
        }

        @NotNull
        Builder setConfigurationAndSettings(@Nullable RunnerAndConfigurationSettings configurationAndSettings) {
            this.myConfigurationAndSettings = configurationAndSettings;
            return this;
        }

        @NotNull
        Builder setSelectDeviceSnapshotComboBoxSnapshotsEnabledGet(@NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabledGet) {
            this.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet = selectDeviceSnapshotComboBoxSnapshotsEnabledGet;
            return this;
        }

        @NotNull
        Updater build() {
            return new Updater(this);
        }
    }
}

