/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.DeploymentCollections;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.RunningDeviceTarget;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TargetsForReadingSupplier {
    @NotNull
    private final Collection<Device> myDevices;
    @NotNull
    private final Set<Target> myTargets;
    @NotNull
    private final Set<RunningDeviceTarget> myRunningDeviceTargetsToRemove;

    TargetsForReadingSupplier(@NotNull Collection<Device> devices2, @Nullable RunningDeviceTarget runningDeviceTarget, @Nullable Target target2) {
        this(devices2, DeploymentCollections.toList(runningDeviceTarget), DeploymentCollections.toList(target2));
    }

    TargetsForReadingSupplier(@NotNull Collection<Device> devices2, @NotNull Collection<RunningDeviceTarget> runningDeviceTargets, @NotNull Collection<Target> targets) {
        this.myDevices = devices2;
        int size = devices2.size();
        this.myTargets = Sets.newHashSetWithExpectedSize((int)size);
        this.myRunningDeviceTargetsToRemove = Sets.newHashSetWithExpectedSize((int)size);
        runningDeviceTargets.forEach(runningDeviceTarget -> {
            if (this.isDeviceRunning((Target)runningDeviceTarget)) {
                this.myTargets.add((Target)runningDeviceTarget);
            } else {
                this.myRunningDeviceTargetsToRemove.add((RunningDeviceTarget)runningDeviceTarget);
            }
        });
        targets.stream().map(this::newRunningDeviceTargetIfDeviceIsRunning).forEach(this.myTargets::add);
    }

    @NotNull
    private Target newRunningDeviceTargetIfDeviceIsRunning(@NotNull Target target2) {
        if (this.isDeviceRunning(target2)) {
            return new RunningDeviceTarget(target2.getDeviceKey());
        }
        return target2;
    }

    private boolean isDeviceRunning(@NotNull Target target2) {
        Key key = target2.getDeviceKey();
        return this.myDevices.stream().filter(Device::isConnected).map(Device::getKey).anyMatch(key::equals);
    }

    @NotNull
    Optional<Target> getDropDownTarget() {
        return DeploymentCollections.toOptional(this.myTargets);
    }

    @NotNull
    Optional<RunningDeviceTarget> getDropDownRunningDeviceTargetToRemove() {
        return DeploymentCollections.toOptional(this.myRunningDeviceTargetsToRemove);
    }

    @NotNull
    Set<Target> getDialogTargets() {
        return this.myTargets;
    }

    @NotNull
    Set<RunningDeviceTarget> getDialogRunningDeviceTargetsToRemove() {
        return this.myRunningDeviceTargetsToRemove;
    }
}

