/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

abstract class Target {
    @NotNull
    private final Key myDeviceKey;

    Target(@NotNull Key deviceKey) {
        this.myDeviceKey = deviceKey;
    }

    @NotNull
    static List<Device> filterDevices(@NotNull Set<Target> targets, @NotNull List<Device> devices2) {
        Set keys = targets.stream().map(Target::getDeviceKey).collect(Collectors.toSet());
        return devices2.stream().filter(device2 -> keys.contains(device2.getKey())).collect(Collectors.toList());
    }

    @NotNull
    final Key getDeviceKey() {
        return this.myDeviceKey;
    }

    boolean matches(@NotNull Device device2) {
        return device2.getKey().equals(this.myDeviceKey);
    }

    @NotNull
    abstract String getText(@NotNull Device var1);

    abstract void boot(@NotNull VirtualDevice var1, @NotNull Project var2);
}

