/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTable;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTableModel;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectMultipleDevicesDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<Device> myDevices;
    @NotNull
    private final TableModel myModel;
    @NotNull
    private final Function<Project, DevicesSelectedService> myDevicesSelectedServiceGetInstance;
    @Nullable
    private SelectMultipleDevicesDialogTable myTable;

    SelectMultipleDevicesDialog(@NotNull Project project, @NotNull List<Device> devices2) {
        this(project, devices2, StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED::get, DevicesSelectedService::getInstance);
    }

    @VisibleForTesting
    SelectMultipleDevicesDialog(@NotNull Project project, @NotNull List<Device> devices2, @NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabledGet, @NotNull Function<Project, DevicesSelectedService> devicesSelectedServiceGetInstance) {
        super(project);
        this.myProject = project;
        this.myDevices = devices2;
        this.myModel = new SelectMultipleDevicesDialogTableModel(devices2, selectDeviceSnapshotComboBoxSnapshotsEnabledGet);
        this.myDevicesSelectedServiceGetInstance = devicesSelectedServiceGetInstance;
        this.initTable();
        this.init();
        this.setTitle("Select Multiple Devices");
    }

    private void initTable() {
        this.myTable = new SelectMultipleDevicesDialogTable();
        this.myTable.setModel(this.myModel);
        this.myTable.setSelectedTargets(this.myDevicesSelectedServiceGetInstance.apply(this.myProject).getTargetsSelectedWithDialog(this.myDevices));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        GroupLayout layout = new GroupLayout(panel2);
        JLabel label = new JLabel("Available devices");
        JBScrollPane scrollPane2 = new JBScrollPane((Component)((Object)this.myTable));
        scrollPane2.setPreferredSize((Dimension)JBUI.size((int)556, (int)270));
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addComponent(label).addComponent((Component)scrollPane2);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(label).addComponent((Component)scrollPane2);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout);
        return panel2;
    }

    protected void doOKAction() {
        super.doOKAction();
        assert (this.myTable != null);
        this.myDevicesSelectedServiceGetInstance.apply(this.myProject).setTargetsSelectedWithDialog(this.myTable.getSelectedTargets());
    }

    @VisibleForTesting
    @NotNull
    protected Action getOKAction() {
        return super.getOKAction();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "com.android.tools.idea.run.deployment.SelectMultipleDevicesDialog";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.getTable();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        assert (this.myTable != null);
        Set<Target> targets = this.myTable.getSelectedTargets();
        HashSet keys = Sets.newHashSetWithExpectedSize((int)targets.size());
        boolean duplicateKeys = targets.stream().map(Target::getDeviceKey).anyMatch(key -> !keys.add(key));
        if (duplicateKeys) {
            String message2 = "Some of the selected targets are for the same device. Each target should be for a different device.";
            return new ValidationInfo(message2, null);
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    SelectMultipleDevicesDialogTable getTable() {
        assert (this.myTable != null);
        return this.myTable;
    }
}

