/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.Key;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectDeviceAction
extends AnAction {
    @NotNull
    private final Device myDevice;
    @NotNull
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;

    SelectDeviceAction(@NotNull Device device2, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        this.myDevice = device2;
        this.myComboBoxAction = comboBoxAction;
    }

    @NotNull
    public Device getDevice() {
        return this.myDevice;
    }

    public void update(@NotNull AnActionEvent event2) {
        Presentation presentation = event2.getPresentation();
        presentation.setIcon(this.myDevice.getIcon());
        Collection devices2 = this.myComboBoxAction.getDevices(Objects.requireNonNull(event2.getProject())).orElseThrow(AssertionError::new);
        Key key = Devices.containsAnotherDeviceWithSameName(devices2, this.myDevice) ? this.myDevice.getKey() : null;
        presentation.setText(Devices.getText(this.myDevice, key), false);
    }

    public void actionPerformed(@NotNull AnActionEvent event2) {
        this.myComboBoxAction.setTargetSelectedWithComboBox(Objects.requireNonNull(event2.getProject()), this.myDevice.getDefaultTarget());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SelectDeviceAction)) {
            return false;
        }
        SelectDeviceAction action2 = (SelectDeviceAction)((Object)object);
        return this.myDevice.equals(action2.myDevice) && ((Object)((Object)this.myComboBoxAction)).equals((Object)action2.myComboBoxAction);
    }

    public int hashCode() {
        return 31 * this.myDevice.hashCode() + ((Object)((Object)this.myComboBoxAction)).hashCode();
    }
}

