/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.RunningDeviceTarget;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ui.LayeredIcon;
import icons.StudioIcons;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhysicalDevice
extends Device {
    private static final Icon ourPhoneIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
    private static final Icon ourWearIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_WEAR);
    private static final Icon ourTvIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_TV);

    @NotNull
    static PhysicalDevice newDevice(@NotNull Device device2, @NotNull KeyToConnectionTimeMap map2) {
        Key key = device2.getKey();
        return new Builder().setName(device2.getName()).setLaunchCompatibility(device2.getLaunchCompatibility()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(device2.getAndroidDevice()).setType(device2.getType()).build();
    }

    private PhysicalDevice(@NotNull Builder builder2) {
        super(builder2);
    }

    @Override
    @NotNull
    Icon getIcon() {
        Icon icon2 = switch (this.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case Device.Type.TV -> ourTvIcon;
            case Device.Type.WEAR -> ourWearIcon;
            case Device.Type.PHONE -> ourPhoneIcon;
        };
        return switch (this.getLaunchCompatibility().getState()) {
            default -> throw new IncompatibleClassChangeError();
            case LaunchCompatibility.State.ERROR -> new LayeredIcon(new Icon[]{icon2, StudioIcons.Common.ERROR_DECORATOR});
            case LaunchCompatibility.State.WARNING -> new LayeredIcon(new Icon[]{icon2, AllIcons.General.WarningDecorator});
            case LaunchCompatibility.State.OK -> icon2;
        };
    }

    @Override
    boolean isConnected() {
        return true;
    }

    @Override
    @NotNull
    Collection<Snapshot> getSnapshots() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    Target getDefaultTarget() {
        return new RunningDeviceTarget(this.getKey());
    }

    @Override
    @NotNull
    Collection<Target> getTargets() {
        return Collections.singletonList(new RunningDeviceTarget(this.getKey()));
    }

    @Override
    @NotNull
    ListenableFuture<AndroidVersion> getAndroidVersionAsync() {
        DeploymentApplicationService service = DeploymentApplicationService.getInstance();
        return Futures.transformAsync(this.getDdmlibDeviceAsync(), service::getVersion, (Executor)MoreExecutors.directExecutor());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof PhysicalDevice)) {
            return false;
        }
        Device device2 = (Device)object;
        return this.getName().equals(device2.getName()) && this.getType().equals((Object)device2.getType()) && this.getLaunchCompatibility().equals(device2.getLaunchCompatibility()) && this.getKey().equals(device2.getKey()) && Objects.equals(this.getConnectionTime(), device2.getConnectionTime()) && this.getAndroidDevice().equals(device2.getAndroidDevice());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.getLaunchCompatibility(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice()});
    }

    @VisibleForTesting
    static final class Builder
    extends Device.Builder {
        Builder() {
        }

        @NotNull
        @VisibleForTesting
        Builder setName(@NotNull String name2) {
            this.myName = name2;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setLaunchCompatibility(@NotNull LaunchCompatibility launchCompatibility) {
            this.myLaunchCompatibility = launchCompatibility;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            this.myConnectionTime = connectionTime;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setType(@NotNull Device.Type type) {
            this.myType = type;
            return this;
        }

        @Override
        @NotNull
        PhysicalDevice build() {
            return new PhysicalDevice(this);
        }
    }
}

