/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Key;
import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class KeyToConnectionTimeMap {
    @NotNull
    private final Map<Key, Instant> myMap = new ConcurrentHashMap<Key, Instant>();
    @NotNull
    private final Clock myClock;

    KeyToConnectionTimeMap() {
        this(Clock.systemDefaultZone());
    }

    @VisibleForTesting
    KeyToConnectionTimeMap(@NotNull Clock clock) {
        this.myClock = clock;
    }

    @NotNull
    Instant get(@NotNull Key key) {
        return this.myMap.computeIfAbsent(key, k -> this.myClock.instant());
    }

    void retainAll(@NotNull Collection<Key> keys) {
        this.myMap.keySet().retainAll(keys);
    }
}

