/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Target;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Devices {
    private Devices() {
    }

    static boolean containsAnotherDeviceWithSameName(@NotNull Collection<Device> devices2, @NotNull Device device2) {
        Key key = device2.getKey();
        String name2 = device2.getName();
        return devices2.stream().filter(d -> !d.getKey().equals(key)).map(Device::getName).anyMatch(name2::equals);
    }

    @NotNull
    static Optional<String> getBootOption(@NotNull Device device2, @NotNull Target target2, @NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabledGet) {
        if (!selectDeviceSnapshotComboBoxSnapshotsEnabledGet.getAsBoolean()) {
            return Optional.empty();
        }
        if (device2.isConnected()) {
            return Optional.empty();
        }
        if (device2.getSnapshots().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(target2.getText(device2));
    }

    @NotNull
    static String getText(@NotNull Device device2) {
        return Devices.getText(device2, null);
    }

    @NotNull
    static String getText(@NotNull Device device2, @Nullable Key key) {
        return Devices.getText(device2, key, null);
    }

    @NotNull
    static String getText(@NotNull Device device2, @Nullable Key key, @Nullable String bootOption) {
        return Devices.getText(device2.getName(), key == null ? null : key.toString(), bootOption);
    }

    @NotNull
    private static String getText(@NotNull String device2, @Nullable String key, @Nullable String bootOption) {
        StringBuilder builder2 = new StringBuilder(device2);
        if (key != null) {
            builder2.append(" [").append(key).append(']');
        }
        if (bootOption != null) {
            builder2.append(" - ").append(bootOption);
        }
        return builder2.toString();
    }
}

