/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTarget;
import com.android.tools.idea.run.deployment.DialogSupplier;
import com.android.tools.idea.run.deployment.SelectedDevicesErrorDialog;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceAndSnapshotComboBoxTargetProvider
extends DeployTargetProvider {
    @NotNull
    private final Supplier<DeviceAndSnapshotComboBoxAction> myDeviceAndSnapshotComboBoxActionGetInstance;
    @NotNull
    private final DialogSupplier mySelectedDevicesErrorDialog;

    public DeviceAndSnapshotComboBoxTargetProvider() {
        this(DeviceAndSnapshotComboBoxAction::getInstance, SelectedDevicesErrorDialog::new);
    }

    @VisibleForTesting
    DeviceAndSnapshotComboBoxTargetProvider(@NotNull Supplier<DeviceAndSnapshotComboBoxAction> deviceAndSnapshotComboBoxActionGetInstance, @NotNull DialogSupplier selectedDevicesErrorDialog) {
        this.myDeviceAndSnapshotComboBoxActionGetInstance = deviceAndSnapshotComboBoxActionGetInstance;
        this.mySelectedDevicesErrorDialog = selectedDevicesErrorDialog;
    }

    @Override
    @NotNull
    public String getId() {
        return TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX.name();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Use the device/snapshot drop down";
    }

    @Override
    @NotNull
    public DeployTargetState createState() {
        return DeployTargetState.DEFAULT_STATE;
    }

    @Override
    @NotNull
    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parent2, @NotNull DeployTargetConfigurableContext context2) {
        return DeployTargetConfigurable.DEFAULT_CONFIGURABLE;
    }

    @Override
    public boolean requiresRuntimePrompt(@NotNull Project project) {
        List<Device> devicesWithError = this.selectedDevicesWithError(project);
        if (devicesWithError.isEmpty()) {
            return false;
        }
        boolean anyDeviceHasError = devicesWithError.stream().anyMatch(d -> d.getLaunchCompatibility().getState() == LaunchCompatibility.State.ERROR);
        return anyDeviceHasError || !Objects.equals(project.getUserData(SelectedDevicesErrorDialog.DO_NOT_SHOW_WARNING_ON_DEPLOYMENT), true);
    }

    @NotNull
    private List<Device> selectedDevicesWithError(@NotNull Project project) {
        List<Device> selectedDevices = this.myDeviceAndSnapshotComboBoxActionGetInstance.get().getSelectedDevices(project);
        return selectedDevices.stream().filter(d -> !d.getLaunchCompatibility().getState().equals((Object)LaunchCompatibility.State.OK)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public DeployTarget showPrompt(@NotNull Project project) {
        List<Device> devicesWithError = this.selectedDevicesWithError(project);
        if (!devicesWithError.isEmpty() && !this.mySelectedDevicesErrorDialog.get(project, devicesWithError).showAndGet()) {
            return null;
        }
        return new DeviceAndSnapshotComboBoxTarget(this.myDeviceAndSnapshotComboBoxActionGetInstance.get()::getSelectedTargets);
    }

    @Override
    @NotNull
    public DeployTarget getDeployTarget(@NotNull Project project) {
        return new DeviceAndSnapshotComboBoxTarget(this.myDeviceAndSnapshotComboBoxActionGetInstance.get()::getSelectedTargets);
    }
}

