/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.SelectedTargetSupplier;
import com.android.tools.idea.run.deployment.Target;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class DeviceAndSnapshotComboBoxTarget
implements DeployTarget {
    @NotNull
    private final SelectedTargetSupplier myGetSelectedTargets;
    @NotNull
    private final Supplier<DeviceAndSnapshotComboBoxAction> myDeviceAndSnapshotComboBoxActionGetInstance;

    DeviceAndSnapshotComboBoxTarget(@NotNull SelectedTargetSupplier getSelectedTargets) {
        this(getSelectedTargets, DeviceAndSnapshotComboBoxAction::getInstance);
    }

    @VisibleForTesting
    DeviceAndSnapshotComboBoxTarget(@NotNull SelectedTargetSupplier getSelectedTargets, @NotNull Supplier<DeviceAndSnapshotComboBoxAction> deviceAndSnapshotComboBoxActionGetInstance) {
        this.myGetSelectedTargets = getSelectedTargets;
        this.myDeviceAndSnapshotComboBoxActionGetInstance = deviceAndSnapshotComboBoxActionGetInstance;
    }

    @Override
    public boolean hasCustomRunProfileState(@NotNull Executor executor2) {
        return false;
    }

    @Override
    @NotNull
    public RunProfileState getRunProfileState(@NotNull Executor executor2, @NotNull ExecutionEnvironment environment, @NotNull DeployTargetState state2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DeviceFutures getDevices(@NotNull Project project) {
        List<Device> devices2 = this.myDeviceAndSnapshotComboBoxActionGetInstance.get().getDevices(project).orElse(Collections.emptyList());
        Set<Target> selectedTargets = this.myGetSelectedTargets.get(project, devices2);
        List<Device> selectedDevices = Target.filterDevices(selectedTargets, devices2);
        DeviceAndSnapshotComboBoxTarget.bootAvailableDevices(selectedTargets, selectedDevices, project);
        return DeviceAndSnapshotComboBoxTarget.newDeviceFutures(selectedDevices);
    }

    private static void bootAvailableDevices(@NotNull Collection<Target> selectedTargets, @NotNull Collection<Device> selectedDevices, @NotNull Project project) {
        Map<Key, Target> map2 = selectedTargets.stream().collect(Collectors.toMap(Target::getDeviceKey, target2 -> target2));
        selectedDevices.stream().filter(device2 -> !device2.isConnected()).map(VirtualDevice.class::cast).forEach(virtualDevice -> ((Target)map2.get(virtualDevice.getKey())).boot((VirtualDevice)virtualDevice, project));
    }

    @NotNull
    private static DeviceFutures newDeviceFutures(@NotNull Collection<Device> selectedDevices) {
        List<AndroidDevice> devices2 = selectedDevices.stream().map(Device::getAndroidDevice).collect(Collectors.toList());
        return new DeviceFutures(devices2);
    }
}

