/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.configuration.AndroidWearConfiguration;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Loggers;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.concurrency.AppExecutorUtil;
import icons.StudioIcons;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DeviceAndSnapshotComboBoxExecutionTarget
extends AndroidExecutionTarget {
    @NotNull
    private final Collection<Key> myKeys;
    @NotNull
    private final AsyncDevicesGetter myDevicesGetter;

    DeviceAndSnapshotComboBoxExecutionTarget(@NotNull Collection<Target> targets, @NotNull AsyncDevicesGetter devicesGetter) {
        this.myKeys = targets.stream().map(Target::getDeviceKey).collect(Collectors.toSet());
        this.myDevicesGetter = devicesGetter;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> isApplicationRunningAsync(@NotNull String appPackage) {
        List futures = this.deviceStream().map(device2 -> device2.isRunningAsync(appPackage)).collect(Collectors.toList());
        return Futures.transform((ListenableFuture)Futures.successfulAsList(futures), runnings -> runnings.contains(true), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Override
    public int getAvailableDeviceCount() {
        return (int)this.deviceStream().count();
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<IDevice>> getRunningDevicesAsync() {
        List futures = this.deviceStream().filter(Device::isConnected).map(Device::getDdmlibDeviceAsync).collect(Collectors.toList());
        ListenableFuture future2 = Futures.successfulAsList(futures);
        return Futures.transform((ListenableFuture)future2, DeviceAndSnapshotComboBoxExecutionTarget::filterNonNull, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    @NotNull
    public Collection<IDevice> getRunningDevices() {
        if (Thread.currentThread().getName().equals("Action Updater (Common)") || EventQueue.isDispatchThread()) {
            Loggers.errorConditionally(DeviceAndSnapshotComboBoxExecutionTarget.class, "Blocking Future::get calls on an Action Updater (Common) thread or the EDT http://b/259746412, http://b/259746444, http://b/259746749, http://b/259747002, http://b/259747870, and http://b/259747965");
        }
        return this.deviceStream().filter(Device::isConnected).map(Device::getDdmlibDeviceAsync).map(Futures::getUnchecked).collect(Collectors.toList());
    }

    @NotNull
    private Stream<Device> deviceStream() {
        return this.myDevicesGetter.get().map(this::filteredStream).orElseGet(Stream::empty);
    }

    @NotNull
    private Stream<Device> filteredStream(@NotNull Collection<Device> devices2) {
        return devices2.stream().filter(device2 -> this.myKeys.contains(device2.getKey()));
    }

    @NotNull
    public String getId() {
        return this.myKeys.stream().sorted().map(Object::toString).collect(Collectors.joining(", ", "device_and_snapshot_combo_box_target[", "]"));
    }

    @NotNull
    public String getDisplayName() {
        List<Device> devices2 = this.deviceStream().toList();
        return switch (devices2.size()) {
            case 0 -> "No Devices";
            case 1 -> devices2.get(0).getName();
            default -> "Multiple Devices";
        };
    }

    @NotNull
    public Icon getIcon() {
        List<Device> devices2 = this.deviceStream().toList();
        if (devices2.size() == 1) {
            return devices2.get(0).getIcon();
        }
        return StudioIcons.DeviceExplorer.MULTIPLE_DEVICES;
    }

    public boolean canRun(@NotNull RunConfiguration configuration) {
        Boolean deploysToLocalDevice = false;
        if (configuration instanceof UserDataHolderBase) {
            deploysToLocalDevice = (Boolean)((UserDataHolderBase)configuration).getUserData(DeviceAndSnapshotComboBoxAction.DEPLOYS_TO_LOCAL_DEVICE);
        }
        return configuration instanceof AndroidRunConfigurationBase || configuration instanceof AndroidWearConfiguration || deploysToLocalDevice != null && deploysToLocalDevice != false;
    }

    @NotNull
    private static Collection<IDevice> filterNonNull(@NotNull Collection<IDevice> devices2) {
        return devices2.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

