/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Loggers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.serviceContainer.NonInjectable;
import java.awt.EventQueue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceAndSnapshotComboBoxDeployableProvider
implements DeployableProvider {
    @NotNull
    private final Supplier<DeviceAndSnapshotComboBoxAction> myDeviceAndSnapshotComboBoxActionGetInstance;
    @NotNull
    private final Supplier<Logger> myLoggerGetInstance;
    private boolean myStackTraceLoggedOnce;

    private DeviceAndSnapshotComboBoxDeployableProvider() {
        this(DeviceAndSnapshotComboBoxAction::getInstance, () -> Logger.getInstance(DeviceAndSnapshotComboBoxDeployableProvider.class));
    }

    @NonInjectable
    @VisibleForTesting
    DeviceAndSnapshotComboBoxDeployableProvider(@NotNull Supplier<DeviceAndSnapshotComboBoxAction> deviceAndSnapshotComboBoxActionGetInstance, @NotNull Supplier<Logger> loggerGetInstance) {
        this.myDeviceAndSnapshotComboBoxActionGetInstance = deviceAndSnapshotComboBoxActionGetInstance;
        this.myLoggerGetInstance = loggerGetInstance;
    }

    @Override
    @Nullable
    public Deployable getDeployable(@NotNull RunConfiguration runConfiguration) {
        if (!(runConfiguration instanceof AndroidRunConfigurationBase)) {
            return null;
        }
        AndroidRunConfigurationBase androidRunConfiguration = (AndroidRunConfigurationBase)runConfiguration;
        List<Device> devices2 = this.myDeviceAndSnapshotComboBoxActionGetInstance.get().getSelectedDevices(androidRunConfiguration.getProject());
        if (devices2.size() != 1) {
            return null;
        }
        ApplicationIdProvider applicationIdProvider = androidRunConfiguration.getApplicationIdProvider();
        if (applicationIdProvider == null) {
            return null;
        }
        return this.getPackageName(applicationIdProvider).map(name2 -> new DeployableDevice((Device)devices2.get(0), (String)name2)).orElse(null);
    }

    @NotNull
    private Optional<String> getPackageName(@NotNull ApplicationIdProvider provider2) {
        try {
            String name2 = provider2.getPackageName();
            this.myStackTraceLoggedOnce = false;
            return Optional.of(name2);
        }
        catch (ApkProvisionException exception) {
            if (!this.myStackTraceLoggedOnce) {
                this.myLoggerGetInstance.get().warn((Throwable)exception);
                this.myStackTraceLoggedOnce = true;
            } else {
                this.myLoggerGetInstance.get().warn("An ApkProvisionException has been thrown more than once: " + exception);
            }
            return Optional.empty();
        }
    }

    @VisibleForTesting
    static final class DeployableDevice
    implements Deployable {
        @NotNull
        private final Device myDevice;
        @NotNull
        private final String myPackageName;

        @VisibleForTesting
        DeployableDevice(@NotNull Device device2, @NotNull String packageName2) {
            this.myDevice = device2;
            this.myPackageName = packageName2;
        }

        @Override
        @NotNull
        public ListenableFuture<AndroidVersion> getVersionAsync() {
            return this.myDevice.getAndroidVersionAsync();
        }

        @Override
        @NotNull
        public ListenableFuture<List<Client>> searchClientsForPackageAsync() {
            ListenableFuture<IDevice> future2 = this.myDevice.getDdmlibDeviceAsync();
            return Futures.transform(future2, device2 -> Deployable.searchClientsForPackage(device2, this.myPackageName), (Executor)MoreExecutors.directExecutor());
        }

        @Override
        @NotNull
        public List<Client> searchClientsForPackage() {
            if (EventQueue.isDispatchThread()) {
                Loggers.errorConditionally(DeviceAndSnapshotComboBoxDeployableProvider.class, "Blocking Future::get call on the EDT http://b/261492787");
            }
            return (List)Futures.getUnchecked(this.searchClientsForPackageAsync());
        }

        @Override
        @NotNull
        public ListenableFuture<Boolean> isOnlineAsync() {
            if (!this.myDevice.getAndroidDevice().isRunning()) {
                return Futures.immediateFuture((Object)false);
            }
            return Futures.transform(this.myDevice.getDdmlibDeviceAsync(), IDevice::isOnline, (Executor)MoreExecutors.directExecutor());
        }

        @Override
        public boolean isOnline() {
            if (EventQueue.isDispatchThread()) {
                Loggers.errorConditionally(DeviceAndSnapshotComboBoxDeployableProvider.class, "Blocking Future::get call on the EDT http://b/261756103");
            }
            return (Boolean)Futures.getUnchecked(this.isOnlineAsync());
        }

        @Override
        @NotNull
        public ListenableFuture<Boolean> isUnauthorizedAsync() {
            if (!this.myDevice.getAndroidDevice().isRunning()) {
                return Futures.immediateFuture((Object)false);
            }
            ListenableFuture<IDevice> future2 = this.myDevice.getDdmlibDeviceAsync();
            Executor executor2 = MoreExecutors.directExecutor();
            return Futures.transform(future2, device2 -> Objects.equals(device2.getState(), IDevice.DeviceState.UNAUTHORIZED), (Executor)executor2);
        }

        @Override
        public boolean isUnauthorized() {
            if (EventQueue.isDispatchThread()) {
                Loggers.errorConditionally(DeviceAndSnapshotComboBoxDeployableProvider.class, "Blocking Future::get call on the EDT http://b/261768533");
            }
            return (Boolean)Futures.getUnchecked(this.isUnauthorizedAsync());
        }

        public int hashCode() {
            return 31 * this.myDevice.hashCode() + this.myPackageName.hashCode();
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof DeployableDevice)) {
                return false;
            }
            DeployableDevice device2 = (DeployableDevice)object;
            return this.myDevice.equals(device2.myDevice) && this.myPackageName.equals(device2.myPackageName);
        }
    }
}

