/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.Target;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Device {
    @NotNull
    private final String myName;
    @NotNull
    private final Type myType;
    @NotNull
    private final LaunchCompatibility myLaunchCompatibility;
    @NotNull
    private final Key myKey;
    @Nullable
    private final Instant myConnectionTime;
    @NotNull
    private final AndroidDevice myAndroidDevice;

    Device(@NotNull Builder builder2) {
        assert (builder2.myName != null);
        this.myName = builder2.myName;
        this.myType = builder2.myType;
        this.myLaunchCompatibility = builder2.myLaunchCompatibility;
        assert (builder2.myKey != null);
        this.myKey = builder2.myKey;
        this.myConnectionTime = builder2.myConnectionTime;
        assert (builder2.myAndroidDevice != null);
        this.myAndroidDevice = builder2.myAndroidDevice;
    }

    @NotNull
    final LaunchCompatibility getLaunchCompatibility() {
        return this.myLaunchCompatibility;
    }

    @NotNull
    abstract Icon getIcon();

    abstract boolean isConnected();

    @NotNull
    public final String getName() {
        return this.myName;
    }

    @NotNull
    abstract Collection<Snapshot> getSnapshots();

    @NotNull
    public final Key getKey() {
        return this.myKey;
    }

    @Nullable
    final Instant getConnectionTime() {
        return this.myConnectionTime;
    }

    @NotNull
    abstract Target getDefaultTarget();

    @NotNull
    abstract Collection<Target> getTargets();

    @NotNull
    final AndroidDevice getAndroidDevice() {
        return this.myAndroidDevice;
    }

    @NotNull
    abstract ListenableFuture<AndroidVersion> getAndroidVersionAsync();

    @NotNull
    final ListenableFuture<Boolean> isRunningAsync(@NotNull String appPackage) {
        if (!this.isConnected()) {
            return Futures.immediateFuture((Object)false);
        }
        return Futures.transform(this.getDdmlibDeviceAsync(), device2 -> Device.isRunning(device2, appPackage), (Executor)MoreExecutors.directExecutor());
    }

    private static boolean isRunning(@NotNull IDevice device2, @NotNull String appPackage) {
        if (!device2.isOnline()) {
            return false;
        }
        return !Deployable.searchClientsForPackage(device2, appPackage).isEmpty();
    }

    @NotNull
    final ListenableFuture<IDevice> getDdmlibDeviceAsync() {
        AndroidDevice device2 = this.getAndroidDevice();
        if (!device2.isRunning()) {
            throw new RuntimeException(device2 + " is not running");
        }
        return device2.getLaunchedDevice();
    }

    @NotNull
    public final String toString() {
        return this.myName;
    }

    @NotNull
    final Type getType() {
        return this.myType;
    }

    static abstract class Builder {
        @Nullable
        String myName;
        @NotNull
        LaunchCompatibility myLaunchCompatibility = LaunchCompatibility.YES;
        @Nullable
        Key myKey;
        @Nullable
        Instant myConnectionTime;
        @Nullable
        AndroidDevice myAndroidDevice;
        @NotNull
        Type myType = Type.PHONE;

        Builder() {
        }

        @NotNull
        abstract Device build();
    }

    static enum Type {
        PHONE,
        WEAR,
        TV;

    }
}

