/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.run.deployment.AndroidDebugBridge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DdmlibAndroidDebugBridge
implements AndroidDebugBridge {
    @NotNull
    private final ListeningExecutorService myExecutorService;
    @NotNull
    private final Supplier<Path> myGetAdb;
    @NotNull
    private final AsyncFunction<Path, com.android.ddmlib.AndroidDebugBridge> myGetDebugBridge;

    DdmlibAndroidDebugBridge(@NotNull Project project) {
        this(MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService()), () -> DdmlibAndroidDebugBridge.getAdb(project), (AsyncFunction<Path, com.android.ddmlib.AndroidDebugBridge>)((AsyncFunction)DdmlibAndroidDebugBridge::getDebugBridge));
    }

    @VisibleForTesting
    DdmlibAndroidDebugBridge(@NotNull ListeningExecutorService executorService, @NotNull Supplier<Path> getAdb, @NotNull AsyncFunction<Path, com.android.ddmlib.AndroidDebugBridge> getDebugBridge) {
        this.myExecutorService = executorService;
        this.myGetAdb = getAdb;
        this.myGetDebugBridge = getDebugBridge;
    }

    @WorkerThread
    @Nullable
    private static Path getAdb(@NotNull Project project) {
        return Optional.ofNullable(AndroidSdkUtils.getAdb(project)).map(File::toPath).orElse(null);
    }

    @WorkerThread
    @NotNull
    private static ListenableFuture<com.android.ddmlib.AndroidDebugBridge> getDebugBridge(@Nullable Path adb) {
        return adb == null ? Futures.immediateFuture(null) : AdbService.getInstance().getDebugBridge(adb.toFile());
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<IDevice>> getConnectedDevices() {
        return FluentFuture.from((ListenableFuture)this.myExecutorService.submit(this.myGetAdb::get)).transformAsync(this.myGetDebugBridge, (Executor)this.myExecutorService).transform(DdmlibAndroidDebugBridge::getDevices, (Executor)this.myExecutorService);
    }

    @WorkerThread
    @NotNull
    private static Collection<IDevice> getDevices(com.android.ddmlib.AndroidDebugBridge bridge) {
        if (bridge == null) {
            return Collections.emptyList();
        }
        if (!bridge.isConnected()) {
            return Collections.emptyList();
        }
        return Arrays.asList(bridge.getDevices());
    }
}

