/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.AvdData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.AndroidDebugBridge;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.SerialNumber;
import com.android.tools.idea.run.deployment.Tasks;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConnectedDevicesTask
implements AsyncSupplier<Collection<ConnectedDevice>> {
    @NotNull
    private final AndroidDebugBridge myAndroidDebugBridge;
    @Nullable
    private final LaunchCompatibilityChecker myLaunchCompatibilityChecker;
    @NotNull
    private final Function<IDevice, AndroidDevice> myNewConnectedAndroidDevice;

    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, @Nullable LaunchCompatibilityChecker launchCompatibilityChecker) {
        this(androidDebugBridge, launchCompatibilityChecker, ConnectedAndroidDevice::new);
    }

    @VisibleForTesting
    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, @Nullable LaunchCompatibilityChecker launchCompatibilityChecker, @NotNull Function<IDevice, AndroidDevice> newConnectedAndroidDevice) {
        this.myAndroidDebugBridge = androidDebugBridge;
        this.myLaunchCompatibilityChecker = launchCompatibilityChecker;
        this.myNewConnectedAndroidDevice = newConnectedAndroidDevice;
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<ConnectedDevice>> get() {
        return Futures.transformAsync(this.myAndroidDebugBridge.getConnectedDevices(), this::toList, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private ListenableFuture<Collection<ConnectedDevice>> toList(@NotNull Collection<IDevice> devices2) {
        List<ListenableFuture> futures = devices2.stream().filter(IDevice::isOnline).map(this::buildAsync).toList();
        return Futures.transform((ListenableFuture)Futures.successfulAsList(futures), ConnectedDevicesTask::filterNonNull, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private ListenableFuture<ConnectedDevice> buildAsync(@NotNull IDevice device2) {
        AndroidDevice androidDevice = this.myNewConnectedAndroidDevice.apply(device2);
        ListenableFuture<String> nameFuture = ConnectedDevicesTask.getNameAsync(device2);
        ListenableFuture<Key> keyFuture = ConnectedDevicesTask.getKeyAsync(device2);
        ListenableFuture<Optional<LaunchCompatibility>> compatibilityFuture = this.getLaunchCompatibilityAsync(androidDevice);
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{nameFuture, keyFuture, compatibilityFuture}).call(() -> ConnectedDevicesTask.build(androidDevice, (Future<String>)nameFuture, (Future<Key>)keyFuture, (Future<Optional<LaunchCompatibility>>)compatibilityFuture), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static ListenableFuture<String> getNameAsync(@NotNull IDevice device2) {
        ExecutorService executor2 = AppExecutorUtil.getAppExecutorService();
        if (device2.isEmulator()) {
            return Futures.transform((ListenableFuture)device2.getAvdData(), d -> ConnectedDevicesTask.getName(d, device2.getSerialNumber()), (Executor)executor2);
        }
        ListenableFuture modelFuture = device2.getSystemProperty("ro.product.model");
        ListenableFuture manufacturerFuture = device2.getSystemProperty("ro.product.manufacturer");
        return Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{modelFuture, manufacturerFuture}).call(() -> DeviceNameProperties.getName((String)Futures.getDone((Future)modelFuture), (String)Futures.getDone((Future)manufacturerFuture)), (Executor)executor2);
    }

    @NotNull
    private static String getName(@Nullable AvdData device2, @NotNull String serialNumber) {
        if (device2 == null) {
            return serialNumber;
        }
        String name2 = device2.getName();
        if (name2 == null) {
            return serialNumber;
        }
        if (name2.equals("<build>")) {
            return serialNumber;
        }
        return name2;
    }

    @NotNull
    private static ListenableFuture<Key> getKeyAsync(@NotNull IDevice device2) {
        String serialNumber = device2.getSerialNumber();
        if (!device2.isEmulator()) {
            return Futures.immediateFuture((Object)new SerialNumber(serialNumber));
        }
        return Futures.transform((ListenableFuture)device2.getAvdData(), d -> ConnectedDevicesTask.getKey(d, serialNumber), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static Key getKey(@Nullable AvdData device2, @NotNull String serialNumber) {
        if (device2 == null) {
            return new SerialNumber(serialNumber);
        }
        String path2 = device2.getPath();
        if (path2 != null) {
            return new VirtualDevicePath(path2);
        }
        String name2 = device2.getName();
        if (name2 == null) {
            return new SerialNumber(serialNumber);
        }
        if (name2.equals("<build>")) {
            return new SerialNumber(serialNumber);
        }
        return new VirtualDeviceName(name2);
    }

    @NotNull
    private ListenableFuture<Optional<LaunchCompatibility>> getLaunchCompatibilityAsync(@NotNull AndroidDevice device2) {
        if (this.myLaunchCompatibilityChecker == null) {
            return Futures.immediateFuture(Optional.empty());
        }
        return Futures.submit(() -> Optional.of(this.myLaunchCompatibilityChecker.validate(device2)), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static ConnectedDevice build(@NotNull AndroidDevice device2, @NotNull Future<String> nameFuture, @NotNull Future<Key> keyFuture, @NotNull Future<Optional<LaunchCompatibility>> compatibilityFuture) throws ExecutionException {
        ConnectedDevice.Builder builder2 = new ConnectedDevice.Builder().setName((String)Futures.getDone(nameFuture)).setKey((Key)Futures.getDone(keyFuture)).setAndroidDevice(device2).setType(Tasks.getTypeFromAndroidDevice(device2));
        ((Optional)Futures.getDone(compatibilityFuture)).ifPresent(builder2::setLaunchCompatibility);
        return builder2.build();
    }

    @NotNull
    private static Collection<ConnectedDevice> filterNonNull(@NotNull Collection<ConnectedDevice> devices2) {
        return devices2.stream().filter(Objects::nonNull).toList();
    }
}

