/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.Target;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BootWithSnapshotTarget
extends Target {
    @NotNull
    private final Path mySnapshotKey;

    BootWithSnapshotTarget(@NotNull Key deviceKey, @NotNull Path snapshotKey) {
        super(deviceKey);
        this.mySnapshotKey = snapshotKey;
    }

    @NotNull
    Path getSnapshotKey() {
        return this.mySnapshotKey;
    }

    @Override
    boolean matches(@NotNull Device device2) {
        if (!device2.getKey().equals(this.getDeviceKey())) {
            return false;
        }
        return device2.getSnapshots().stream().map(Snapshot::getDirectory).anyMatch(snapshotKey -> snapshotKey.equals(this.mySnapshotKey));
    }

    @Override
    @NotNull
    String getText(@NotNull Device device2) {
        Optional<String> text2 = device2.getSnapshots().stream().filter(snapshot -> snapshot.getDirectory().equals(this.mySnapshotKey)).map(Snapshot::toString).findFirst();
        return text2.orElseThrow(AssertionError::new);
    }

    @Override
    void boot(@NotNull VirtualDevice device2, @NotNull Project project) {
        device2.bootWithSnapshot(project, this.mySnapshotKey.getFileName());
    }

    public int hashCode() {
        return 31 * this.getDeviceKey().hashCode() + this.mySnapshotKey.hashCode();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof BootWithSnapshotTarget)) {
            return false;
        }
        BootWithSnapshotTarget target2 = (BootWithSnapshotTarget)object;
        return this.getDeviceKey().equals(target2.getDeviceKey()) && this.mySnapshotKey.equals(target2.mySnapshotKey);
    }
}

