/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class DeviceVersion
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final Map<IDevice, ListenableFuture<AndroidVersion>> myVersions = new ConcurrentHashMap<IDevice, ListenableFuture<AndroidVersion>>();

    public DeviceVersion() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @NotNull
    public ListenableFuture<AndroidVersion> get(@NotNull IDevice iDevice) {
        return this.myVersions.compute(iDevice, (d, f) -> {
            if (f != null && f.isDone()) {
                try {
                    AndroidVersion version2 = (AndroidVersion)f.get();
                    if (version2 != AndroidVersion.DEFAULT) {
                        return f;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return Futures.submit(() -> DeviceVersion.getVersion(d), (Executor)AppExecutorUtil.getAppExecutorService());
        });
    }

    @NotNull
    private static AndroidVersion getVersion(@NotNull IDevice device2) {
        try {
            String level = device2.getProperty("ro.build.version.sdk");
            if (level == null) {
                return AndroidVersion.DEFAULT;
            }
            return new AndroidVersion(Integer.parseInt(level), device2.getProperty("ro.build.version.codename"));
        }
        catch (Exception exception) {
            return AndroidVersion.DEFAULT;
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge != null && bridge.isConnected() && bridge.hasInitialDeviceList()) {
            this.myVersions.keySet().retainAll(Arrays.asList(bridge.getDevices()));
        } else {
            this.myVersions.clear();
        }
    }

    public void deviceConnected(IDevice device2) {
    }

    public void deviceDisconnected(IDevice device2) {
        this.myVersions.remove(device2);
    }

    public void deviceChanged(IDevice device2, int changeMask) {
    }
}

