/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration.execution;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.ComponentType;
import com.android.tools.deployer.model.component.Tile;
import com.android.tools.deployer.model.component.WearComponent;
import com.android.tools.idea.execution.common.AppRunSettings;
import com.android.tools.idea.execution.common.ComponentLaunchOptions;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.configuration.execution.AddTileCommandResultReceiver;
import com.android.tools.idea.run.configuration.execution.AndroidTileConfigurationExecutorKt;
import com.android.tools.idea.run.configuration.execution.AndroidWearConfigurationExecutor;
import com.android.tools.idea.run.configuration.execution.ConsoleOutputReceiver;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.android.tools.idea.run.configuration.execution.RecordOutputReceiver;
import com.android.tools.idea.run.configuration.execution.SurfaceVersionException;
import com.android.tools.idea.run.configuration.execution.TileLaunchOptions;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J0\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J1\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010!J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/run/configuration/execution/AndroidTileConfigurationExecutor;", "Lcom/android/tools/idea/run/configuration/execution/AndroidWearConfigurationExecutor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "deviceFutures", "Lcom/android/tools/idea/run/DeviceFutures;", "appRunSettings", "Lcom/android/tools/idea/execution/common/AppRunSettings;", "applicationIdProvider", "Lcom/android/tools/idea/run/ApplicationIdProvider;", "apkProvider", "Lcom/android/tools/idea/run/ApkProvider;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/android/tools/idea/run/DeviceFutures;Lcom/android/tools/idea/execution/common/AppRunSettings;Lcom/android/tools/idea/run/ApplicationIdProvider;Lcom/android/tools/idea/run/ApkProvider;)V", "tileLaunchOptions", "Lcom/android/tools/idea/run/configuration/execution/TileLaunchOptions;", "getStopCallback", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "console", "Lcom/intellij/execution/ui/ConsoleView;", "isDebug", "", "launch", "device", "app", "Lcom/android/tools/deployer/model/App;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "setWatchTile", "", "mode", "Lcom/android/tools/deployer/model/component/AppComponent$Mode;", "(Lcom/android/tools/deployer/model/App;Lcom/android/tools/deployer/model/component/AppComponent$Mode;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/execution/ui/ConsoleView;)Ljava/lang/Integer;", "verifyResponse", "receiver", "Lcom/android/tools/deployer/model/component/WearComponent$CommandResultReceiver;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nAndroidTileConfigurationExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTileConfigurationExecutor.kt\ncom/android/tools/idea/run/configuration/execution/AndroidTileConfigurationExecutor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public class AndroidTileConfigurationExecutor
extends AndroidWearConfigurationExecutor {
    @NotNull
    private final TileLaunchOptions tileLaunchOptions;

    public AndroidTileConfigurationExecutor(@NotNull ExecutionEnvironment environment, @NotNull DeviceFutures deviceFutures, @NotNull AppRunSettings appRunSettings2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)deviceFutures, (String)"deviceFutures");
        Intrinsics.checkNotNullParameter((Object)appRunSettings2, (String)"appRunSettings");
        Intrinsics.checkNotNullParameter((Object)applicationIdProvider, (String)"applicationIdProvider");
        Intrinsics.checkNotNullParameter((Object)apkProvider, (String)"apkProvider");
        super(environment, deviceFutures, appRunSettings2, applicationIdProvider, apkProvider);
        ComponentLaunchOptions componentLaunchOptions = appRunSettings2.getComponentLaunchOptions();
        Intrinsics.checkNotNull((Object)componentLaunchOptions, (String)"null cannot be cast to non-null type com.android.tools.idea.run.configuration.execution.TileLaunchOptions");
        this.tileLaunchOptions = (TileLaunchOptions)componentLaunchOptions;
    }

    @Override
    @NotNull
    protected Function1<IDevice, Unit> getStopCallback(@NotNull ConsoleView console, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        String string = this.getAppId();
        String string2 = this.tileLaunchOptions.getComponentName();
        Intrinsics.checkNotNull((Object)string2);
        String tileName = AppComponent.getFQEscapedName((String)string, (String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)tileName, (String)"tileName");
        return AndroidTileConfigurationExecutorKt.access$getStopTileCallback(tileName, console, isDebug);
    }

    @Override
    @WorkerThread
    public void launch(@NotNull IDevice device2, @NotNull App app, @NotNull ConsoleView console, boolean isDebug, @NotNull ProgressIndicator indicator) {
        Integer tileIndex;
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ProgressManager.checkCanceled();
        AppComponent.Mode mode = isDebug ? AppComponent.Mode.DEBUG : AppComponent.Mode.RUN;
        int version2 = ExecutionUtils.getWearDebugSurfaceVersion(device2, indicator);
        if (version2 < 2) {
            throw new SurfaceVersionException(2, version2, device2.isEmulator());
        }
        if (version2 < 3) {
            String string = AndroidBundle.message("android.run.configuration.debug.surface.warn", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.run.con\u2026tion.debug.surface.warn\")");
            ExecutionUtils.printlnError(console, string);
        }
        Thread.sleep(Duration.ofSeconds(2L).toMillis());
        Integer n = tileIndex = this.setWatchTile(app, mode, indicator, console);
        Intrinsics.checkNotNull((Object)n);
        String showTileCommand = Tile.ShellCommand.SHOW_TILE_COMMAND + n;
        WearComponent.CommandResultReceiver showTileReceiver = new WearComponent.CommandResultReceiver();
        ExecutionUtils.executeShellCommand$default(device2, showTileCommand, console, (IShellOutputReceiver)showTileReceiver, 0L, null, indicator, 24, null);
        this.verifyResponse(showTileReceiver, console);
    }

    private final Integer setWatchTile(App app, AppComponent.Mode mode, ProgressIndicator indicator, ConsoleView console) {
        RecordOutputReceiver outputReceiver2 = new RecordOutputReceiver((Function0<Boolean>)((Function0)new Function0<Boolean>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ProgressIndicator progressIndicator = this.$indicator;
                return progressIndicator != null ? progressIndicator.isCanceled() : false;
            }
        }));
        ConsoleOutputReceiver consoleReceiver2 = new ConsoleOutputReceiver((Function0<Boolean>)((Function0)new Function0<Boolean>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ProgressIndicator progressIndicator = this.$indicator;
                return progressIndicator != null ? progressIndicator.isCanceled() : false;
            }
        }), console);
        AddTileCommandResultReceiver indexReceiver2 = new AddTileCommandResultReceiver((Function0<Boolean>)((Function0)new Function0<Boolean>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ProgressIndicator progressIndicator = this.$indicator;
                return progressIndicator != null ? progressIndicator.isCanceled() : false;
            }
        }));
        IShellOutputReceiver[] iShellOutputReceiverArray = new IShellOutputReceiver[]{outputReceiver2, consoleReceiver2, indexReceiver2};
        MultiReceiver receiver2 = new MultiReceiver(iShellOutputReceiverArray);
        try {
            ComponentType componentType = this.tileLaunchOptions.getComponentType();
            String string = this.tileLaunchOptions.getComponentName();
            Intrinsics.checkNotNull((Object)string);
            app.activateComponent(componentType, string, mode, (IShellOutputReceiver)receiver2);
        }
        catch (DeployerException ex) {
            CharSequence charSequence;
            CharSequence charSequence2 = outputReceiver2.getOutput();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = ex.getDetails();
            } else {
                charSequence = charSequence2;
            }
            Throwable throwable = ex;
            String string = "Error while setting the tile, message: " + charSequence;
            throw new ExecutionException(string, throwable);
        }
        if (indexReceiver2.getIndex() == null) {
            throw new ExecutionException("Tile index was not found.");
        }
        Integer n = indexReceiver2.getIndex();
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    private final void verifyResponse(WearComponent.CommandResultReceiver receiver2, ConsoleView console) {
        if (receiver2.getResultCode() != 1) {
            ExecutionUtils.printlnError(console, "Warning: Launch was successful, but you may need to bring up the tile manually.");
        }
    }
}

