/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration;

import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.deployer.model.component.Complication;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.manifest.parser.BinaryXmlParser;
import com.android.tools.manifest.parser.XmlNode;
import com.android.zipflinger.ZipRepo;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u001a&\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00060\u00060\u00032\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0001\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a8\u0006\u001d"}, d2={"checkRawComplicationTypes", "", "supportedTypesStr", "", "", "extractServiceXmlNodeFromApks", "Lcom/android/tools/manifest/parser/XmlNode;", "apks", "", "Lcom/android/tools/idea/run/ApkInfo;", "componentName", "extractSupportedComplicationTypes", "snapshot", "Lcom/android/tools/idea/model/MergedManifestSnapshot;", "complicationServiceName", "service", "getChildrenWithName", "kotlin.jvm.PlatformType", "node", "name", "getComplicationSourceTypes", "getComplicationTypesFromManifest", "module", "Lcom/intellij/openapi/module/Module;", "complicationName", "parseRawComplicationTypes", "Lcom/android/tools/deployer/model/component/Complication$ComplicationType;", "splitTypesString", "types", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nComplicationTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplicationTypeUtils.kt\ncom/android/tools/idea/run/configuration/ComplicationTypeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 NodeCollectionHelper.kt\ncom/android/utils/NodeCollectionHelperKt\n*L\n1#1,115:1\n1603#2,9:116\n1851#2:125\n1852#2:127\n1612#2:128\n766#2:129\n857#2,2:130\n1851#2,2:136\n1#3:126\n1#3:132\n26#4,3:133\n29#4:138\n*S KotlinDebug\n*F\n+ 1 ComplicationTypeUtils.kt\ncom/android/tools/idea/run/configuration/ComplicationTypeUtilsKt\n*L\n41#1:116,9\n41#1:125\n41#1:127\n41#1:128\n67#1:129\n67#1:130,2\n103#1:136,2\n41#1:126\n103#1:133,3\n103#1:138\n*E\n"})
public final class ComplicationTypeUtilsKt {
    @WorkerThread
    @NotNull
    public static final List<String> getComplicationTypesFromManifest(@NotNull Module module2, @NotNull String complicationName) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)complicationName, (String)"complicationName");
        Object object = MergedManifestManager.Companion.getMergedManifestSupplier(module2).get().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MergedManifestManager.ge\u2026plier(module).get().get()");
        return ComplicationTypeUtilsKt.extractSupportedComplicationTypes((MergedManifestSnapshot)object, complicationName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Complication.ComplicationType> parseRawComplicationTypes(@NotNull List<String> supportedTypesStr) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(supportedTypesStr, (String)"supportedTypesStr");
        Iterable $this$mapNotNull$iv = supportedTypesStr;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Complication.ComplicationType it$iv$iv;
            Complication.ComplicationType complicationType;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                complicationType = Complication.ComplicationType.valueOf((String)it);
            }
            catch (IllegalArgumentException e) {
                complicationType = null;
            }
            if (complicationType == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final void checkRawComplicationTypes(@NotNull List<String> supportedTypesStr) {
        Intrinsics.checkNotNullParameter(supportedTypesStr, (String)"supportedTypesStr");
        for (String typeStr : supportedTypesStr) {
            try {
                Complication.ComplicationType.valueOf((String)typeStr);
            }
            catch (IllegalArgumentException e) {
                Object[] objectArray = new Object[]{typeStr};
                throw new RuntimeConfigurationWarning(AndroidBundle.message("provider.type.invalid.error", objectArray));
            }
        }
    }

    @NotNull
    public static final List<String> getComplicationSourceTypes(@NotNull Collection<ApkInfo> apks2, @NotNull String componentName) {
        Intrinsics.checkNotNullParameter(apks2, (String)"apks");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        XmlNode complicationService = ComplicationTypeUtilsKt.extractServiceXmlNodeFromApks(apks2, componentName);
        return ComplicationTypeUtilsKt.extractSupportedComplicationTypes(complicationService);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<XmlNode> getChildrenWithName(XmlNode node, String name2) {
        void $this$filterTo$iv$iv;
        List list2 = node.children();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"node.children()");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            XmlNode it = (XmlNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.name(), (Object)name2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final XmlNode extractServiceXmlNodeFromApks(Collection<ApkInfo> apks2, String componentName) {
        for (ApkInfo apk : apks2) {
            for (ApkFileUnit apkFileUnit : apk.getFiles()) {
                XmlNode serviceNode;
                Closeable closeable;
                block15: {
                    XmlNode application;
                    InputStream inputStream;
                    String ext;
                    File file2;
                    Intrinsics.checkNotNullExpressionValue((Object)apkFileUnit.getApkFile(), (String)"apkFileUnit.apkFile");
                    String string = file2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (!StringsKt.endsWith$default((String)ext, (String)".apk", (boolean)false, (int)2, null)) continue;
                    Closeable closeable2 = (Closeable)new ZipRepo(file2.getAbsolutePath());
                    Throwable throwable = null;
                    try {
                        ZipRepo repo = (ZipRepo)closeable2;
                        boolean bl = false;
                        InputStream manifestEntry = repo.getInputStream("AndroidManifest.xml");
                        Closeable closeable3 = manifestEntry;
                        Throwable throwable2 = null;
                        try {
                            InputStream inputStream2 = (InputStream)closeable3;
                            boolean bl2 = false;
                            inputStream2 = BinaryXmlParser.parse((InputStream)inputStream2);
                        }
                        catch (Throwable inputStream2) {
                            throwable2 = inputStream2;
                            throw inputStream2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable2);
                        }
                        inputStream = inputStream2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                    }
                    InputStream parsedXml = inputStream;
                    Intrinsics.checkNotNullExpressionValue((Object)parsedXml, (String)"parsedXml");
                    if ((XmlNode)CollectionsKt.singleOrNull(ComplicationTypeUtilsKt.getChildrenWithName((XmlNode)parsedXml, "application")) == null) continue;
                    Iterable iterable = ComplicationTypeUtilsKt.getChildrenWithName(application, "service");
                    for (Closeable closeable3 : iterable) {
                        XmlNode it = (XmlNode)closeable3;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.attributes().get("name"), (Object)componentName)) continue;
                        closeable = closeable3;
                        break block15;
                    }
                    closeable = null;
                }
                if ((serviceNode = (XmlNode)closeable) == null) continue;
                return serviceNode;
            }
        }
        throw new IllegalStateException("Complication service " + componentName + " is not found in the manifest.");
    }

    private static final List<String> extractSupportedComplicationTypes(XmlNode service) {
        XmlNode supportedTypesNode;
        Object object;
        Object v1;
        block2: {
            List list2 = service.children();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"service.children()");
            Iterable iterable = list2;
            for (Object t : iterable) {
                XmlNode it = (XmlNode)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.attributes().get("name"), (Object)"android.support.wearable.complications.SUPPORTED_TYPES")) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((object = (supportedTypesNode = (XmlNode)v1)) == null || (object = object.attributes()) == null || (object = (String)object.get("value")) == null) {
            object = "";
        }
        Object rawTypes = object;
        return ComplicationTypeUtilsKt.splitTypesString((String)rawTypes);
    }

    @NotNull
    public static final List<String> extractSupportedComplicationTypes(@NotNull MergedManifestSnapshot snapshot, @NotNull String complicationServiceName) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            Intrinsics.checkNotNullParameter((Object)complicationServiceName, (String)"complicationServiceName");
            List<Element> list2 = snapshot.getServices();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"snapshot.services");
            Iterable iterable = list2;
            for (Object t : iterable) {
                Element it = (Element)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)complicationServiceName, (Object)it.getAttributeNS("http://schemas.android.com/apk/res/android", "name"))) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        Element element2 = v1;
        if (element2 == null) {
            return CollectionsKt.emptyList();
        }
        Element complicationTag = element2;
        NodeList metaDataTags = complicationTag.getElementsByTagName("meta-data");
        Intrinsics.checkNotNullExpressionValue((Object)metaDataTags, (String)"metaDataTags");
        NodeList $this$forEach$iv = metaDataTags;
        boolean $i$f$forEach = false;
        ArrayList<Node> copy$iv = new ArrayList<Node>($this$forEach$iv.getLength());
        int it = $this$forEach$iv.getLength();
        for (int i$iv = 0; i$iv < it; ++i$iv) {
            copy$iv.add($this$forEach$iv.item(i$iv));
        }
        Iterable $this$forEach$iv$iv = copy$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            String string;
            String string2;
            Node it$iv = (Node)element$iv$iv;
            boolean bl = false;
            Node it2 = it$iv;
            boolean bl2 = false;
            Node node = it2.getAttributes().getNamedItemNS("http://schemas.android.com/apk/res/android", "name");
            String metaDataType = node != null ? node.getNodeValue() : null;
            if (!Intrinsics.areEqual((Object)metaDataType, (Object)"android.support.wearable.complications.SUPPORTED_TYPES")) continue;
            Node node2 = it2.getAttributes().getNamedItemNS("http://schemas.android.com/apk/res/android", "value");
            String string3 = string2 = node2 != null ? node2.getNodeValue() : null;
            if (string3 == null) {
                string = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.attributes.getNamedIt\u2026R_VALUE)?.nodeValue ?: \"\"");
                string = string2;
            }
            String rawTypes = string;
            return ComplicationTypeUtilsKt.splitTypesString(rawTypes);
        }
        return CollectionsKt.emptyList();
    }

    private static final List<String> splitTypesString(String types2) {
        String[] stringArray = (String[])types2;
        Regex regex = new Regex("\\s+");
        String string = "";
        CharSequence charSequence = regex.replace((CharSequence)stringArray, string);
        stringArray = new String[]{","};
        return StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }
}

